/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.ident;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.dgc.VMID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.util.SecurityUtility;

public class Identity
implements Serializable {
    static final long serialVersionUID = -2788084303665751253L;
    private static transient Random random = new Random(System.currentTimeMillis());
    public static transient String DEFAULT_DOMAIN;
    private static transient String _domain;
    private static transient Map identities;
    private static final Logger log;
    private static final InetAddress LOCAL_HOST;
    private final String instanceid;
    private final InetAddress ip;
    private final String serverid;
    private String domain;
    private int hashCode;

    private static InetAddress getLocalHost() throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return Identity.doGetLocalHost();
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return Identity.doGetLocalHost();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static InetAddress doGetLocalHost() throws UnknownHostException {
        if (LOCAL_HOST != null) {
            return LOCAL_HOST;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getByName("127.0.0.1");
        }
    }

    private Identity(InetAddress addr, String instanceid, String serverid) {
        this.ip = addr;
        this.instanceid = instanceid;
        this.serverid = serverid;
        this.domain = _domain == null || _domain.equals("") ? DEFAULT_DOMAIN : _domain;
        this.calcHashCode();
    }

    private void calcHashCode() {
        this.hashCode = this.ip.hashCode() + this.instanceid.hashCode() + this.serverid.hashCode() - this.domain.hashCode();
    }

    public static void setDomain(String domain) {
        Iterator iter = identities.keySet().iterator();
        while (iter.hasNext()) {
            Identity ident = (Identity)identities.get(iter.next());
            if (ident != null) {
                ident.domain = domain;
            }
            ident.calcHashCode();
        }
        Identity.setSystemProperty("jboss.identity.domain", domain);
        _domain = domain;
        NetworkRegistry.getInstance().changeDomain(domain);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "JBOSS Identity\n\taddress:" + this.ip + "\n\tinstanceid:" + this.instanceid + "\n\tJMX id:" + this.serverid + "\n\tdomain:" + this.domain + "\n";
    }

    public final String getDomain() {
        return this.domain;
    }

    public String getInstanceId() {
        return this.instanceid;
    }

    public InetAddress getAddress() {
        return this.ip;
    }

    public String getJMXId() {
        return this.serverid;
    }

    public boolean isSameJVM(Identity identity) {
        return identity.equals(this);
    }

    public boolean isSameInstance(Identity identity) {
        return identity.getInstanceId().equals(this.instanceid);
    }

    public boolean isSameMachine(Identity identity) {
        return identity.getAddress().equals(this.ip);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Identity) {
            return this.hashCode == obj.hashCode();
        }
        return false;
    }

    public static final synchronized Identity get(MBeanServer server) {
        if (identities.containsKey(server)) {
            return (Identity)identities.get(server);
        }
        try {
            InetAddress localHost = Identity.getLocalHost();
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            String serverid = (String)Identity.getMBeanAttribute(server, objectName, "MBeanServerId");
            Identity identity = new Identity(localHost, Identity.createId(server), serverid);
            identities.put(server, identity);
            return identity;
        }
        catch (Exception ex) {
            String type = ex.getClass().getName();
            RuntimeException rex = new RuntimeException("Exception creating identity: " + type + ": " + ex.getMessage());
            rex.setStackTrace(ex.getStackTrace());
            throw rex;
        }
    }

    private static final synchronized String createId(MBeanServer server) {
        File dir;
        String myid = Identity.getSystemProperty("jboss.identity");
        if (myid != null) {
            return myid;
        }
        String id = null;
        File file = null;
        try {
            ObjectName obj = new ObjectName("jboss.system:type=ServerConfig");
            dir = (File)Identity.getMBeanAttribute(server, obj, "ServerDataDir");
            if (dir != null) {
                if (!Identity.fileExists(dir)) {
                    Identity.mkdirs(dir);
                }
                file = new File(dir, "jboss.identity");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (file == null) {
            String fl = Identity.getSystemProperty("jboss.identity.dir", ".");
            dir = new File(fl);
            if (!Identity.fileExists(dir)) {
                Identity.mkdirs(dir);
            }
            file = new File(dir, "jboss.identity");
        }
        boolean canRead = Identity.canRead(file);
        if (Identity.fileExists(file) && canRead) {
            FileInputStream is = null;
            try {
                is = Identity.getFileInputStream(file);
                byte[] buf = new byte[800];
                int c = ((InputStream)is).read(buf);
                id = new String(buf, 0, c);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error loading jboss.identity: " + ex.toString());
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception ig) {}
                }
            }
        }
        OutputStream out = null;
        try {
            id = Identity.createUniqueID();
            if (!Identity.fileExists(file)) {
                Identity.createNewFile(file);
            }
            out = Identity.getFileOutputStream(file);
            out.write(id.getBytes());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating Instance ID: " + ex.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception ig) {}
            }
        }
        Identity.setSystemProperty("jboss.identity", id);
        return id;
    }

    public static final String createUniqueID() {
        String id = new VMID().toString();
        return id.replace(':', 'x') + random.nextInt(1000);
    }

    private static boolean fileExists(final File file) {
        if (file == null) {
            return false;
        }
        if (SecurityUtility.skipAccessControl()) {
            return file.exists();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    private static boolean mkdirs(final File dir) {
        if (SecurityUtility.skipAccessControl()) {
            return dir.mkdirs();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(dir.mkdirs());
            }
        });
    }

    private static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    private static FileOutputStream getFileOutputStream(final File file) throws FileNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return new FileOutputStream(file);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    private static boolean canRead(final File file) {
        if (SecurityUtility.skipAccessControl()) {
            return file.canRead();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.canRead());
            }
        });
    }

    private static boolean createNewFile(final File file) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return file.createNewFile();
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(file.createNewFile());
                }
            });
        }
        catch (Exception e) {
            throw (IOException)e.getCause();
        }
    }

    private static Object getMBeanAttribute(final MBeanServer server, final ObjectName objectName, final String attribute) throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            return server.getAttribute(objectName, attribute);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return server.getAttribute(objectName, attribute);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name, defaultValue);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static String getSystemProperty(final String name) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static void setSystemProperty(final String name, final String value) {
        if (SecurityUtility.skipAccessControl()) {
            System.setProperty(name, value);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.setProperty(name, value);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    static {
        _domain = DEFAULT_DOMAIN = "JBOSS";
        _domain = Identity.getSystemProperty("jboss.identity.domain", DEFAULT_DOMAIN);
        identities = new WeakHashMap(2);
        log = Logger.getLogger(Identity.class);
        try {
            LOCAL_HOST = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            log.debug((Object)(Identity.class.getName() + " unable to get local host address"), e.getCause());
            throw new ExceptionInInitializerError(e.getCause());
        }
        catch (SecurityException e) {
            log.debug((Object)(Identity.class.getName() + " unable to get local host address"), (Throwable)e);
            throw e;
        }
    }
}

