/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.security.ExternalPasswordCache;
import org.jboss.security.PasswordCache;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;

public class Util {
    private static PasswordCache externalPasswordCache;

    public static char[] loadPassword(String passwordCmd) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(Util.class.getName() + ".loadPassword"));
        }
        char[] password = null;
        String passwordCmdType = null;
        if (passwordCmd.charAt(0) == '{') {
            StringTokenizer tokenizer = new StringTokenizer(passwordCmd, "{}");
            passwordCmdType = tokenizer.nextToken();
            passwordCmd = tokenizer.nextToken();
        } else {
            password = passwordCmd.toCharArray();
        }
        if (password == null) {
            if (passwordCmdType.startsWith("EXTC")) {
                long timeOut = 0L;
                if (passwordCmdType.indexOf(58) > -1) {
                    try {
                        String[] token = passwordCmdType.split(":");
                        timeOut = Long.parseLong(token[1]);
                    }
                    catch (Throwable e) {
                        PicketBoxLogger.LOGGER.errorParsingTimeoutNumber();
                    }
                }
                if (externalPasswordCache == null) {
                    externalPasswordCache = ExternalPasswordCache.getExternalPasswordCacheInstance();
                }
                if (externalPasswordCache.contains(passwordCmd, timeOut)) {
                    password = externalPasswordCache.getPassword(passwordCmd);
                } else {
                    password = Util.execPasswordCmd(passwordCmd);
                    if (password != null) {
                        externalPasswordCache.storePassword(passwordCmd, password);
                    }
                }
            } else if (passwordCmdType.startsWith("EXT")) {
                password = Util.execPasswordCmd(passwordCmd);
            } else if (passwordCmdType.equals("CLASS")) {
                password = Util.invokePasswordClass(passwordCmd);
            } else {
                throw PicketBoxMessages.MESSAGES.invalidPasswordCommandType(passwordCmdType);
            }
        }
        return password;
    }

    private static char[] execPasswordCmd(String passwordCmd) throws Exception {
        PicketBoxLogger.LOGGER.traceBeginExecPasswordCmd(passwordCmd);
        String password = Util.execCmd(passwordCmd);
        return password.toCharArray();
    }

    private static char[] invokePasswordClass(String passwordCmd) throws Exception {
        char[] password;
        block6: {
            password = null;
            String classname = passwordCmd;
            String ctorArgs = null;
            int colon = passwordCmd.indexOf(58);
            if (colon > 0) {
                classname = passwordCmd.substring(0, colon);
                ctorArgs = passwordCmd.substring(colon + 1);
            }
            ClassLoader loader = AccessController.doPrivileged(GetTCLAction.ACTION);
            Class<?> c = loader.loadClass(classname);
            Object instance = null;
            if (ctorArgs != null) {
                Object[] args = ctorArgs.split(",");
                Class[] sig = new Class[args.length];
                ArrayList<Class<String>> sigl = new ArrayList<Class<String>>();
                for (int n = 0; n < args.length; ++n) {
                    sigl.add(String.class);
                }
                sigl.toArray(sig);
                Constructor<?> ctor = c.getConstructor(sig);
                instance = ctor.newInstance(args);
            } else {
                instance = c.newInstance();
            }
            try {
                Class[] sig = new Class[]{};
                Method toCharArray = c.getMethod("toCharArray", sig);
                Object[] args = new Object[]{};
                password = (char[])toCharArray.invoke(instance, args);
            }
            catch (NoSuchMethodException e) {
                String tmp = instance.toString();
                if (tmp == null) break block6;
                password = tmp.toCharArray();
            }
        }
        return password;
    }

    private static String execCmd(String cmd) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        String line = sm != null ? RuntimeActions.PRIVILEGED.execCmd(cmd) : RuntimeActions.NON_PRIVILEGED.execCmd(cmd);
        return line;
    }

    static interface RuntimeActions {
        public static final RuntimeActions PRIVILEGED = new RuntimeActions(){

            @Override
            public String execCmd(final String cmd) throws Exception {
                try {
                    String line = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return NON_PRIVILEGED.execCmd(cmd);
                        }
                    });
                    return line;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };
        public static final RuntimeActions NON_PRIVILEGED = new RuntimeActions(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String execCmd(String cmd) throws Exception {
                String line;
                Runtime rt = Runtime.getRuntime();
                Process p = rt.exec(cmd);
                InputStream stdin = null;
                BufferedReader reader = null;
                try {
                    stdin = p.getInputStream();
                    reader = new BufferedReader(new InputStreamReader(stdin));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stdin != null) {
                        stdin.close();
                    }
                }
                int exitCode = p.waitFor();
                PicketBoxLogger.LOGGER.traceEndExecPasswordCmd(exitCode);
                return line;
            }
        };

        public String execCmd(String var1) throws Exception;
    }

    private static class GetTCLAction
    implements PrivilegedAction<ClassLoader> {
        static PrivilegedAction<ClassLoader> ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

