/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.Date;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class CheckSubDeploymentCompleteDeployer
extends AbstractDeployer {
    private MainDeployerImpl mainDeployer;
    private long version = new Date().getTime();
    private String types;
    private String[] checkTypes = new String[0];

    public void setMainDeployer(MainDeployerImpl md) {
        this.mainDeployer = md;
    }

    public void create() {
        this.setStage(DeploymentStages.INSTALLED);
        if (this.types != null) {
            this.checkTypes = this.types.split(",");
        }
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        boolean requiresCheck = true;
        if (unit.getParent() != null) {
            return;
        }
        for (String type : this.checkTypes) {
            requiresCheck = false;
            if (!unit.getSimpleName().endsWith(type)) continue;
            requiresCheck = true;
            break;
        }
        if (requiresCheck) {
            this.mainDeployer.checkComplete(new String[]{unit.getName()});
        } else {
            this.log.trace((Object)("Unit name " + unit.getSimpleName() + " does not end in one of these types: " + this.types));
        }
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }
}

