/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.plugins.inflow.GetTCLAction;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb.plugins.inflow.SetTCLAction;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.proxy.Interceptor;

public class MessageEndpointInterceptor
extends Interceptor {
    private static final long serialVersionUID = -8740717288847385688L;
    private static final Logger log = Logger.getLogger(MessageEndpointInterceptor.class);
    public static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpoint.Factory";
    public static final String MESSAGE_ENDPOINT_XARESOURCE = "MessageEndpoint.XAResource";
    private boolean trace = log.isTraceEnabled();
    private String cachedProxyString = null;
    protected AtomicBoolean released = new AtomicBoolean(false);
    protected AtomicBoolean delivered = new AtomicBoolean(false);
    protected Thread inUseThread = null;
    protected ClassLoader oldClassLoader = null;
    protected Transaction transaction = null;
    protected Transaction suspended = null;
    protected boolean beforeDeliveryInvoked = false;
    private JBossMessageEndpointFactory endpointFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Throwable {
        if (this.released.get()) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(mi) + " has been released");
        }
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            Thread currentThread = Thread.currentThread();
            if (this.inUseThread != null && !this.inUseThread.equals(currentThread)) {
                throw new IllegalStateException("This message endpoint + " + this.getProxyString(mi) + " is already in use by another thread " + this.inUseThread);
            }
            this.inUseThread = currentThread;
        }
        String method = mi.getMethod().getName();
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " in use by " + method + " " + this.inUseThread));
        }
        if (method.equals("release")) {
            this.release(mi);
            return null;
        }
        if (method.equals("beforeDelivery")) {
            this.before(mi);
            return null;
        }
        if (method.equals("afterDelivery")) {
            this.after(mi);
            return null;
        }
        return this.delivery(mi);
    }

    protected void release(Invocation mi) throws Throwable {
        this.released.set(true);
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " released"));
        }
        if (this.getOldClassLoader() != null) {
            try {
                this.finish("release", mi, false);
            }
            catch (Throwable t) {
                log.warn((Object)"Error in release ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before(Invocation mi) throws Throwable {
        if (this.getBeforeDeliveryInvoke()) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this.getProxyString(mi));
        }
        MessageDrivenContainer container = this.getContainer(mi);
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            this.oldClassLoader = GetTCLAction.getContextClassLoader(this.inUseThread);
            SetTCLAction.setContextClassLoader(this.inUseThread, container.getClassLoader());
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " set context classloader to " + container.getClassLoader()));
        }
        try {
            this.startTransaction("beforeDelivery", mi, container);
            this.setBeforeDeliveryInvoke(true);
        }
        catch (Throwable t) {
            this.setBeforeDeliveryInvoke(false);
            this.resetContextClassLoader(mi);
            throw new ResourceException(t);
        }
    }

    protected void after(Invocation mi) throws Throwable {
        if (!this.getBeforeDeliveryInvoke()) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this.getProxyString(mi));
        }
        try {
            this.finish("afterDelivery", mi, true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object delivery(Invocation mi) throws Throwable {
        if (this.delivered.get()) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + this.getProxyString(mi));
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " delivering"));
        }
        if (this.getOldClassLoader() != null) {
            this.delivered.set(true);
        }
        MessageDrivenContainer container = this.getContainer(mi);
        boolean commit = true;
        if (this.getOldClassLoader() == null) {
            this.startTransaction("delivery", mi, container);
        }
        Object object = this.getNext().invoke(mi);
        Object var7_6 = null;
        if (this.getOldClassLoader() != null) return object;
        try {
            this.endTransaction(mi, commit);
            Object var9_8 = null;
            this.releaseThreadLock(mi);
            return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseThreadLock(mi);
            throw throwable;
        }
        catch (Throwable t) {
            try {
                if (this.trace) {
                    log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " delivery error"), t);
                }
                if (!(t instanceof Error) && !(t instanceof RuntimeException)) throw t;
                Transaction transaction = this.getTransaction();
                if (transaction != null) {
                    transaction.setRollbackOnly();
                }
                commit = false;
                throw t;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.getOldClassLoader() != null) throw throwable;
                try {
                    this.endTransaction(mi, commit);
                    Object var9_10 = null;
                    this.releaseThreadLock(mi);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    this.releaseThreadLock(mi);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(String context, Invocation mi, boolean commit) throws Throwable {
        try {
            this.endTransaction(mi, commit);
            Object var5_4 = null;
            this.setBeforeDeliveryInvoke(false);
            this.delivered.set(false);
            this.resetContextClassLoader(mi);
            this.releaseThreadLock(mi);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setBeforeDeliveryInvoke(false);
            this.delivered.set(false);
            this.resetContextClassLoader(mi);
            this.releaseThreadLock(mi);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startTransaction(String context, Invocation mi, MessageDrivenContainer container) throws Throwable {
        MessageEndpointInterceptor messageEndpointInterceptor2;
        XAResource resource = (XAResource)mi.getInvocationContext().getValue(MESSAGE_ENDPOINT_XARESOURCE);
        Method method = null;
        method = "delivery".equals(context) ? mi.getMethod() : (Method)mi.getArguments()[0];
        boolean isTransacted = this.getMessageEndpointFactory(mi).isDeliveryTransacted(method);
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " " + context + " method=" + method + " xaResource=" + resource + " transacted=" + isTransacted));
        }
        TransactionManager tm = container.getTransactionManager();
        Transaction tx = tm.suspend();
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            this.suspended = tx;
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " " + context + " currentTx=" + this.suspended));
        }
        if (!isTransacted) return;
        if (this.suspended == null) {
            tm.begin();
            tx = tm.getTransaction();
            messageEndpointInterceptor = this;
            synchronized (messageEndpointInterceptor) {
                this.transaction = tx;
            }
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " started transaction=" + this.transaction));
            }
            if (resource == null) return;
            this.transaction.enlistResource(resource);
            if (!this.trace) return;
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " enlisted=" + resource));
            return;
        }
        try {
            tm.resume(this.suspended);
            Object var13_12 = null;
            messageEndpointInterceptor2 = this;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            MessageEndpointInterceptor messageEndpointInterceptor3 = this;
            synchronized (messageEndpointInterceptor3) {
                this.suspended = null;
            }
            if (!this.trace) throw throwable;
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " transaction=" + this.suspended + " already active, IGNORED=" + resource));
            throw throwable;
        }
        synchronized (messageEndpointInterceptor2) {
            this.suspended = null;
        }
        if (!this.trace) return;
        log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " transaction=" + this.suspended + " already active, IGNORED=" + resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(Invocation mi, boolean commit) throws Throwable {
        MessageEndpointInterceptor messageEndpointInterceptor;
        TransactionManager tm = null;
        Transaction currentTx = null;
        try {
            Transaction suspended;
            Transaction transaction = this.getTransaction();
            if (transaction != null) {
                tm = this.getContainer(mi).getTransactionManager();
                currentTx = tm.getTransaction();
                if (currentTx != null && !currentTx.equals(transaction)) {
                    log.warn((Object)("Current transaction " + currentTx + " is not the expected transaction."));
                    tm.suspend();
                    tm.resume(transaction);
                } else {
                    currentTx = null;
                }
                if (!commit || transaction.getStatus() == 1) {
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " rollback"));
                    }
                    tm.rollback();
                } else {
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " commit"));
                    }
                    tm.commit();
                }
            }
            if ((suspended = this.getSuspended()) != null) {
                MessageEndpointInterceptor messageEndpointInterceptor2;
                try {
                    tm = this.getContainer(mi).getTransactionManager();
                    tm.resume(suspended);
                    Object var8_7 = null;
                    messageEndpointInterceptor2 = this;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    MessageEndpointInterceptor messageEndpointInterceptor3 = this;
                    synchronized (messageEndpointInterceptor3) {
                        this.suspended = null;
                    }
                    throw throwable;
                }
                synchronized (messageEndpointInterceptor2) {
                    this.suspended = null;
                }
            }
            Object var12_14 = null;
            messageEndpointInterceptor = this;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            MessageEndpointInterceptor messageEndpointInterceptor4 = this;
            synchronized (messageEndpointInterceptor4) {
                this.transaction = null;
            }
            if (currentTx != null) {
                try {
                    tm.resume(currentTx);
                }
                catch (Throwable t) {
                    log.warn((Object)("MessageEndpoint " + this.getProxyString(mi) + " failed to resume old transaction " + currentTx));
                }
            }
            throw throwable;
        }
        synchronized (messageEndpointInterceptor) {
            this.transaction = null;
        }
        if (currentTx != null) {
            try {
                tm.resume(currentTx);
            }
            catch (Throwable t) {
                log.warn((Object)("MessageEndpoint " + this.getProxyString(mi) + " failed to resume old transaction " + currentTx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetContextClassLoader(Invocation mi) {
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " reset classloader " + this.oldClassLoader));
            }
            SetTCLAction.setContextClassLoader(this.inUseThread, this.oldClassLoader);
            this.oldClassLoader = null;
        }
    }

    protected void setBeforeDeliveryInvoke(boolean bdi) {
        this.beforeDeliveryInvoked = bdi;
    }

    protected boolean getBeforeDeliveryInvoke() {
        return this.beforeDeliveryInvoked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseThreadLock(Invocation mi) {
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " no longer in use by " + this.inUseThread));
            }
            this.inUseThread = null;
        }
    }

    protected String getProxyString(Invocation mi) {
        if (this.cachedProxyString == null) {
            this.cachedProxyString = mi.getInvocationContext().getCacheId().toString();
        }
        return this.cachedProxyString;
    }

    protected JBossMessageEndpointFactory getMessageEndpointFactory(Invocation mi) {
        if (this.endpointFactory == null) {
            this.endpointFactory = (JBossMessageEndpointFactory)mi.getInvocationContext().getValue(MESSAGE_ENDPOINT_FACTORY);
        }
        if (this.endpointFactory == null) {
            throw new IllegalStateException("No message endpoint factory in " + mi.getInvocationContext().context);
        }
        return this.endpointFactory;
    }

    protected MessageDrivenContainer getContainer(Invocation mi) {
        JBossMessageEndpointFactory messageEndpointFactory = this.getMessageEndpointFactory(mi);
        MessageDrivenContainer container = messageEndpointFactory.getContainer();
        if (container == null) {
            throw new IllegalStateException("No container associated with message endpoint factory: " + messageEndpointFactory.getServiceName());
        }
        return container;
    }

    protected synchronized ClassLoader getOldClassLoader() {
        return this.oldClassLoader;
    }

    protected synchronized Transaction getTransaction() {
        return this.transaction;
    }

    protected synchronized Transaction getSuspended() {
        return this.suspended;
    }
}

