/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.txtimer.PersistencePolicy;
import org.jboss.ejb.txtimer.PersistencePolicyExt;
import org.jboss.ejb.txtimer.RetryPolicy;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.ejb.txtimer.TimerIdGenerator;
import org.jboss.ejb.txtimer.TimerImpl;
import org.jboss.ejb.txtimer.TimerRestoringTimerService;
import org.jboss.logging.Logger;

public class TimerServiceImpl
implements TimerRestoringTimerService {
    private static Logger log = Logger.getLogger(TimerServiceImpl.class);
    private TransactionManager transactionManager;
    private PersistencePolicy persistencePolicy;
    private TimerIdGenerator timerIdGenerator;
    private RetryPolicy retryPolicy;
    private TimedObjectId timedObjectId;
    private TimedObjectInvoker timedObjectInvoker;
    private Map timers = new HashMap();
    private final ScheduledExecutorService scheduledExecutorService;

    public TimerServiceImpl(final TimedObjectId timedObjectId, TimedObjectInvoker timedObjectInvoker, TransactionManager transactionManager, PersistencePolicy persistencePolicy, RetryPolicy retryPolicy, TimerIdGenerator timerIdGenerator, int corePoolSize) {
        this.timedObjectId = timedObjectId;
        this.timedObjectInvoker = timedObjectInvoker;
        this.transactionManager = transactionManager;
        this.persistencePolicy = persistencePolicy;
        this.timerIdGenerator = timerIdGenerator;
        this.retryPolicy = retryPolicy;
        final AtomicInteger numThread = new AtomicInteger(0);
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "EJB-Timer-" + numThread.incrementAndGet() + " " + timedObjectId);
            }
        };
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllTimers() {
        Map map = this.timers;
        synchronized (map) {
            return new ArrayList(this.timers.values());
        }
    }

    ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public Timer getTimer(TimerHandle handle) {
        TimerImpl timer = (TimerImpl)this.timers.get(handle);
        if (timer != null && timer.isActive()) {
            return timer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean keepState) {
        this.scheduledExecutorService.shutdown();
        Map map = this.timers;
        synchronized (map) {
            for (TimerImpl timer : this.timers.values()) {
                timer.stopTimer();
                if (keepState) continue;
                this.persistencePolicy.deleteTimer(timer.getTimerId(), timer.getTimedObjectId());
            }
            this.timers.clear();
        }
    }

    public TimedObjectInvoker getTimedObjectInvoker() {
        return this.timedObjectInvoker;
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration is negative");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initial duration is negative");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration is null");
        }
        return this.createTimer(expiration, 0L, info);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info, String timerId) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initial expiration is null");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        if (timerId == null) {
            throw new IllegalArgumentException("timerId is null");
        }
        try {
            TimerImpl timer = new TimerImpl(this, timerId, this.timedObjectId, this.timedObjectInvoker, info);
            this.persistencePolicy.insertTimer(timerId, this.timedObjectId, initialExpiration, intervalDuration, info);
            timer.startTimer(initialExpiration, intervalDuration);
            return timer;
        }
        catch (Exception e) {
            throw new EJBException("Failed to create timer", e);
        }
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initial expiration is null");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        String timerId = this.timerIdGenerator.nextTimerId();
        return this.createTimer(initialExpiration, intervalDuration, info, timerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTimers() throws IllegalStateException, EJBException {
        ArrayList<TimerImpl> activeTimers = new ArrayList<TimerImpl>();
        Map map = this.timers;
        synchronized (map) {
            for (TimerImpl timer : this.timers.values()) {
                if (!timer.isActive()) continue;
                activeTimers.add(timer);
            }
        }
        return activeTimers;
    }

    public Timer restoreTimer(Date initialExpiration, long intervalDuration, Date nextExpiry, Serializable info, String timerId) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initial expiration is null");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        if (timerId == null) {
            throw new IllegalArgumentException("timerId is null");
        }
        try {
            TimerImpl timer = new TimerImpl(this, timerId, this.timedObjectId, this.timedObjectInvoker, info);
            this.persistencePolicy.insertTimer(timerId, this.timedObjectId, initialExpiration, intervalDuration, info);
            if (this.persistencePolicy instanceof PersistencePolicyExt) {
                ((PersistencePolicyExt)this.persistencePolicy).updateNextTimeout(timerId, this.timedObjectId, nextExpiry);
            }
            timer.startTimer(initialExpiration, nextExpiry, intervalDuration);
            return timer;
        }
        catch (Exception e) {
            throw new EJBException("Failed to restore timer", e);
        }
    }

    Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimer(TimerImpl txtimer) {
        Map map = this.timers;
        synchronized (map) {
            TimerHandleImpl handle = new TimerHandleImpl(txtimer);
            this.timers.put(handle, txtimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(TimerImpl txtimer) {
        Map map = this.timers;
        synchronized (map) {
            this.persistencePolicy.deleteTimer(txtimer.getTimerId(), txtimer.getTimedObjectId());
            this.timers.remove(new TimerHandleImpl(txtimer));
        }
    }

    void retryTimeout(TimerImpl txtimer) {
        try {
            this.retryPolicy.retryTimeout(this.timedObjectInvoker, txtimer);
        }
        catch (Exception e) {
            log.error((Object)("Retry timeout failed for timer: " + txtimer), (Throwable)e);
        }
    }

    PersistencePolicy getPersistencePolicy() {
        return this.persistencePolicy;
    }
}

