/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import javax.naming.NamingException;
import org.jboss.naming.NamingAliasMBean;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;

public class NamingAlias
extends ServiceMBeanSupport
implements NamingAliasMBean {
    private String fromName;
    private String toName;

    public NamingAlias() {
        this(null, null);
    }

    public NamingAlias(String fromName, String toName) {
        this.fromName = fromName;
        this.toName = toName;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String name) throws NamingException {
        this.removeLinkRef(this.fromName);
        this.fromName = name;
        this.createLinkRef();
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String name) throws NamingException {
        this.toName = name;
        this.createLinkRef();
    }

    protected void startService() throws Exception {
        if (this.fromName == null) {
            throw new IllegalStateException("fromName is null");
        }
        if (this.toName == null) {
            throw new IllegalStateException("toName is null");
        }
        this.createLinkRef();
    }

    protected void stopService() throws Exception {
        this.removeLinkRef(this.fromName);
    }

    private void createLinkRef() throws NamingException {
        if (super.getState() == 2 || super.getState() == 3) {
            Util.createLinkRef((String)this.fromName, (String)this.toName);
        }
    }

    private void removeLinkRef(String name) throws NamingException {
        if (super.getState() == 1) {
            Util.removeLinkRef((String)name);
        }
    }
}

