/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.factory;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import sun.misc.CompoundEnumeration;

public class WatchfulClassLoader
extends ClassLoader {
    private ClassLoader[] delegates;

    public WatchfulClassLoader(ClassLoader ... delegates) {
        super(null);
        this.delegates = delegates;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.delegates) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        try {
            return super.findClass(name);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Did not find class in:\n" + this.dumpDelegates() + "\nand in current CL", e);
        }
    }

    private String dumpDelegates() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClassLoader cl : this.delegates) {
            stringBuilder.append("\t\n- ").append(cl);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode() + "-[" + this.dumpDelegates() + "]";
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader cl : this.delegates) {
            URL url = cl.getResource(name);
            if (url == null) continue;
            return url;
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[this.delegates.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.delegates[i].getResources(name);
        }
        return new CompoundEnumeration(tmp);
    }
}

