/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.infinispan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.ResponseFilter;
import org.jboss.ha.framework.server.DistributedReplicantManagerImpl;
import org.jboss.legacy.jnp.infinispan.ClusterNodeProxy;
import org.jboss.legacy.jnp.infinispan.HAGroupCommunicationService;
import org.jboss.legacy.jnp.infinispan.HAMembershipListenerAdapter;
import org.jboss.legacy.jnp.infinispan.LegacyClusterNodeAdapter;
import org.jboss.legacy.jnp.infinispan.ResponseFilterAdapter;
import org.jboss.legacy.jnp.infinispan.StateTransferProviderAdapter;

public class InfinispanHAPartition
implements HAPartition {
    private final HAGroupCommunicationService service;
    private final Map<HAPartition.HAMembershipListener, HAMembershipListenerAdapter> groupMembershipListeners = new HashMap<HAPartition.HAMembershipListener, HAMembershipListenerAdapter>();
    private final DistributedReplicantManagerImpl distributedReplicantManager;

    public InfinispanHAPartition(HAGroupCommunicationService service) {
        this.service = service;
        this.distributedReplicantManager = new DistributedReplicantManagerImpl((HAPartition)this);
    }

    public String getNodeName() {
        return this.service.getNodeName();
    }

    public String getPartitionName() {
        return this.service.getGroupName();
    }

    public DistributedReplicantManager getDistributedReplicantManager() {
        return this.distributedReplicantManager;
    }

    public DistributedState getDistributedStateService() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerRPCHandler(String serviceName, Object handler) {
        this.service.registerRPCHandler(serviceName, handler);
    }

    public void registerRPCHandler(String serviceName, Object handler, ClassLoader classloader) {
        this.service.registerRPCHandler(serviceName, handler);
    }

    public void unregisterRPCHandler(String serviceName, Object subscriber) {
        this.service.unregisterRPCHandler(serviceName, subscriber);
    }

    public ArrayList callMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return new ArrayList(this.service.callMethodOnCluster(serviceName, methodName, args, types, excludeSelf));
    }

    public ArrayList callMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf, ResponseFilter filter) throws Exception {
        return new ArrayList(this.service.callMethodOnCluster(serviceName, methodName, args, types, excludeSelf, new ResponseFilterAdapter(filter)));
    }

    public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        this.service.callAsynchMethodOnCluster(serviceName, methodName, args, types, excludeSelf);
    }

    public ArrayList callMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return this.service.callMethodOnCoordinatorNode(serviceName, methodName, args, types, excludeSelf);
    }

    public Object callMethodOnNode(String serviceName, String methodName, Object[] args, Class[] types, long methodTimeout, ClusterNode targetNode) throws Throwable {
        return this.service.callMethodOnNode(serviceName, methodName, args, types, new ClusterNodeProxy(targetNode.getIpAddress(), targetNode.getName(), targetNode.getPort()));
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class[] types, long methodTimeout, ClusterNode targetNode) throws Throwable {
        this.service.callAsyncMethodOnNode(serviceName, methodName, args, types, new ClusterNodeProxy(targetNode.getIpAddress(), targetNode.getName(), targetNode.getPort()));
    }

    public void subscribeToStateTransferEvents(String serviceName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.service.registerStateTransferProvider(serviceName, new StateTransferProviderAdapter(subscriber));
    }

    public void unsubscribeFromStateTransferEvents(String serviceName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.service.unregisterStateTransferProvider(serviceName);
    }

    public void registerMembershipListener(HAPartition.HAMembershipListener listener) {
        this.groupMembershipListeners.put(listener, new HAMembershipListenerAdapter(listener));
        this.service.registerGroupMembershipListener(this.groupMembershipListeners.get(listener));
    }

    public void unregisterMembershipListener(HAPartition.HAMembershipListener listener) {
        this.service.unregisterGroupMembershipListener(this.groupMembershipListeners.get(listener));
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.service.getAllowSynchronousMembershipNotifications();
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.service.setAllowSynchronousMembershipNotifications(allowSync);
    }

    public long getCurrentViewId() {
        return this.service.getCurrentViewId();
    }

    public Vector getCurrentView() {
        return new Vector<String>(this.service.getCurrentView());
    }

    public ClusterNode[] getClusterNodes() {
        return LegacyClusterNodeAdapter.convertToArray(this.service.getClusterNodes());
    }

    public ClusterNode getClusterNode() {
        return new LegacyClusterNodeAdapter(this.service.getClusterNode());
    }

    public void start() throws Exception {
        this.distributedReplicantManager.createService();
        this.distributedReplicantManager.startService();
    }
}

