/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp;

import java.util.HashMap;
import java.util.Map;

public enum JNPSubsystemNamespace {
    UNKNOWN(null),
    LEGACY_JNP_1_0("urn:jboss:domain:legacy-jnp:1.0");

    private final String name;
    private static final Map<String, JNPSubsystemNamespace> MAP;

    private JNPSubsystemNamespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static JNPSubsystemNamespace forUri(String uri) {
        JNPSubsystemNamespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, JNPSubsystemNamespace> map = new HashMap<String, JNPSubsystemNamespace>();
        for (JNPSubsystemNamespace namespace : JNPSubsystemNamespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

