/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.legacy.jnp.connector.JNPServerConnectorResourceDefinition;
import org.jboss.legacy.jnp.connector.JNPServerNamingConnectorService;
import org.jboss.legacy.jnp.connector.clustered.HAConnectorLegacyService;
import org.jboss.legacy.jnp.connector.clustered.HAConnectorService;
import org.jboss.legacy.jnp.connector.simple.SingleConnectorService;
import org.jboss.legacy.jnp.infinispan.DistributedTreeManagerService;
import org.jboss.legacy.jnp.infinispan.InfinispanDistributedTreeManager;
import org.jboss.legacy.jnp.server.JNPServer;
import org.jboss.legacy.jnp.server.JNPServerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class JNPServerConnectorServiceAddStepHandler
extends AbstractBoottimeAddStepHandler {
    public static final JNPServerConnectorServiceAddStepHandler INSTANCE = new JNPServerConnectorServiceAddStepHandler();

    public JNPServerConnectorServiceAddStepHandler() {
        super(new AttributeDefinition[]{JNPServerConnectorResourceDefinition.SOCKET_BINDING, JNPServerConnectorResourceDefinition.RMI_SOCKET_BINDING});
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        newControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ServiceBuilder serviceBuilder;
        JNPServerNamingConnectorService<HAConnectorLegacyService> service;
        ModelNode bindingRefModel = JNPServerConnectorResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, operation);
        ModelNode containerRef = JNPServerConnectorResourceDefinition.CACHE_CONTAINER.resolveModelAttribute(context, operation);
        ServiceTarget serviceTarget = context.getServiceTarget();
        if (containerRef.isDefined()) {
            JNPServerNamingConnectorService<HAConnectorLegacyService> haConnectorService = service = new HAConnectorService();
            serviceBuilder = serviceTarget.addService(JNPServerNamingConnectorService.SERVICE_NAME, (Service)service);
            serviceBuilder.addDependency(CoreGroupCommunicationService.getServiceName((String)containerRef.asString()), CoreGroupCommunicationService.class, ((HAConnectorService)haConnectorService).getCoreGroupCommunicationService()).addDependency(DistributedTreeManagerService.SERVICE_NAME, InfinispanDistributedTreeManager.class, ((HAConnectorService)haConnectorService).getDistributedTreeManager()).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, ((HAConnectorService)haConnectorService).getNamingStoreValue());
        } else {
            service = new SingleConnectorService();
            serviceBuilder = serviceTarget.addService(JNPServerNamingConnectorService.SERVICE_NAME, (Service)service);
            serviceBuilder.addDependency(JNPServerService.SERVICE_NAME, JNPServer.class, ((SingleConnectorService)service).getJNPServer());
        }
        serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRefModel.asString()}), SocketBinding.class, service.getBinding());
        ModelNode rmiBindingRefModel = JNPServerConnectorResourceDefinition.RMI_SOCKET_BINDING.resolveModelAttribute(context, operation);
        if (rmiBindingRefModel.isDefined()) {
            serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{rmiBindingRefModel.asString()}), SocketBinding.class, service.getRmiBinding());
        } else {
            service.getRmiBinding().inject(null);
        }
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController remotingServiceController = serviceBuilder.install();
        ArrayList installedServices = new ArrayList();
        installedServices.add(remotingServiceController);
        return installedServices;
    }
}

