/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.connector.clustered;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.GroupMembershipListener;
import org.jboss.as.clustering.ResponseFilter;
import org.jboss.as.clustering.StateTransferProvider;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.legacy.jnp.infinispan.ClusterListener;
import org.jboss.legacy.jnp.infinispan.ClusterNodeAdapter;
import org.jboss.legacy.jnp.infinispan.ClusterNodeProxy;
import org.jboss.legacy.jnp.infinispan.ClusterResponseFilter;
import org.jboss.legacy.jnp.infinispan.ClusterResponseFilterAdapter;
import org.jboss.legacy.jnp.infinispan.ClusterStateTransferProvider;
import org.jboss.legacy.jnp.infinispan.ClusterStateTransferProviderAdapter;
import org.jboss.legacy.jnp.infinispan.GroupMembershipListenerAdapter;
import org.jboss.legacy.jnp.infinispan.HAGroupCommunicationService;
import org.jboss.msc.service.ServiceName;

public class InfinispanGroupCommunicationService
implements HAGroupCommunicationService {
    private final CoreGroupCommunicationService service;

    public InfinispanGroupCommunicationService(CoreGroupCommunicationService service) {
        this.service = service;
    }

    public static ServiceName getServiceName(String name) {
        return CoreGroupCommunicationService.getServiceName((String)name);
    }

    public String getNodeName() {
        return this.service.getNodeName();
    }

    public String getGroupName() {
        return this.service.getGroupName();
    }

    public List<String> getCurrentView() {
        return this.service.getCurrentView();
    }

    public long getCurrentViewId() {
        return this.service.getCurrentViewId();
    }

    public List<ClusterNodeProxy> getClusterNodes() {
        ArrayList<ClusterNodeProxy> result = new ArrayList<ClusterNodeProxy>();
        for (ClusterNode node : this.service.getClusterNodes()) {
            result.add(new ClusterNodeProxy(node.getIpAddress(), node.getName(), node.getPort()));
        }
        return result;
    }

    public ClusterNodeProxy getClusterNode() {
        ClusterNode node = this.service.getClusterNode();
        if (node != null) {
            return new ClusterNodeProxy(node.getIpAddress(), node.getName(), node.getPort());
        }
        return null;
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.service.registerRPCHandler(objName, subscriber);
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.service.unregisterRPCHandler(objName, subscriber);
    }

    public List callMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return this.service.callMethodOnCluster(serviceName, methodName, args, types, excludeSelf);
    }

    public List callMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf, ClusterResponseFilter filter) throws Exception {
        return this.service.callMethodOnCluster(serviceName, methodName, args, types, excludeSelf, (ResponseFilter)new ClusterResponseFilterAdapter(filter));
    }

    public Object callMethodOnNode(String serviceName, String methodName, Object[] args, Class[] types, ClusterNodeProxy targetNode) throws Exception {
        return this.service.callMethodOnNode(serviceName, methodName, args, types, (ClusterNode)new ClusterNodeAdapter(targetNode));
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class[] types, ClusterNodeProxy targetNode) throws Exception {
        this.service.callAsyncMethodOnNode(serviceName, methodName, args, types, (ClusterNode)new ClusterNodeAdapter(targetNode));
    }

    public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        this.service.callAsynchMethodOnCluster(serviceName, methodName, args, types, excludeSelf);
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.service.getAllowSynchronousMembershipNotifications();
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.service.setAllowSynchronousMembershipNotifications(allowSync);
    }

    public void registerGroupMembershipListener(ClusterListener listener) {
        this.service.registerGroupMembershipListener((GroupMembershipListener)new GroupMembershipListenerAdapter(listener));
    }

    public void unregisterGroupMembershipListener(ClusterListener listener) {
        this.service.unregisterGroupMembershipListener((GroupMembershipListener)new GroupMembershipListenerAdapter(listener));
    }

    public void registerStateTransferProvider(String serviceName, ClusterStateTransferProvider provider) {
        this.service.registerStateTransferProvider(serviceName, (StateTransferProvider)new ClusterStateTransferProviderAdapter(provider));
    }

    public void unregisterStateTransferProvider(String serviceName) {
        this.service.unregisterStateTransferProvider(serviceName);
    }

    public ArrayList callMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return (ArrayList)this.service.callMethodOnCoordinatorNode(serviceName, methodName, args, types, excludeSelf);
    }
}

