/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.connector.simple;

import org.jboss.as.network.SocketBinding;
import org.jboss.legacy.jnp.JNPLogger;
import org.jboss.legacy.jnp.JNPMessages;
import org.jboss.legacy.jnp.connector.JNPServerNamingConnectorService;
import org.jboss.legacy.jnp.connector.simple.SingleConnectorLegacyService;
import org.jboss.legacy.jnp.server.JNPServer;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SingleConnectorService
implements JNPServerNamingConnectorService<SingleConnectorLegacyService> {
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<SocketBinding> rmiBinding = new InjectedValue();
    private final InjectedValue<JNPServer> jnpServer = new InjectedValue();
    private SingleConnectorLegacyService serverConnector;

    public InjectedValue<JNPServer> getJNPServer() {
        return this.jnpServer;
    }

    @Override
    public InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    @Override
    public InjectedValue<SocketBinding> getRmiBinding() {
        return this.rmiBinding;
    }

    public SingleConnectorLegacyService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.serverConnector;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            SocketBinding socketBinding;
            SocketBinding rmiSocketBinding = socketBinding = (SocketBinding)this.getBinding().getValue();
            if (this.getRmiBinding().getOptionalValue() != null) {
                rmiSocketBinding = (SocketBinding)this.getRmiBinding().getOptionalValue();
                this.serverConnector = new SingleConnectorLegacyService((JNPServer)this.jnpServer.getValue(), socketBinding.getAddress().getHostName(), socketBinding.getAbsolutePort(), rmiSocketBinding.getAddress().getHostName(), rmiSocketBinding.getAbsolutePort());
            } else {
                this.serverConnector = new SingleConnectorLegacyService((JNPServer)this.jnpServer.getValue(), socketBinding.getAddress().getHostName(), socketBinding.getAbsolutePort());
            }
            JNPLogger.ROOT_LOGGER.startSingletonConnectorService(socketBinding.getName(), socketBinding.getAddress(), socketBinding.getAbsolutePort(), rmiSocketBinding.getName(), rmiSocketBinding.getAddress(), rmiSocketBinding.getAbsolutePort());
            this.serverConnector.start();
        }
        catch (Exception e) {
            throw JNPMessages.MESSAGES.failedToStartSingletonConnectorService(e);
        }
    }

    public void stop(StopContext stopContext) {
        JNPLogger.ROOT_LOGGER.stopSingletonConnectorService();
        try {
            this.serverConnector.stop();
        }
        catch (Exception ex) {
            JNPLogger.ROOT_LOGGER.couldNotStopSingletonConnectorService(ex);
        }
        this.serverConnector = null;
    }
}

