/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.jboss.as.naming.NamingContext;
import org.jboss.legacy.jnp.infinispan.InfinispanDistributedCacheTree;
import org.jboss.legacy.jnp.infinispan.PseudoBinding;
import org.jboss.logging.Logger;

public class InfinispanDistributedTreeManager
implements InfinispanDistributedCacheTree {
    static final long serialVersionUID = 6342802270002172451L;
    private static Logger log = Logger.getLogger(InfinispanDistributedTreeManager.class);
    public static final String DEFAULT_ROOT = "__HA_JNDI__";
    private TreeCache<String, Binding> cache;
    private Fqn m_root;
    private boolean treeRootSet;
    protected boolean acquiredCache = false;

    public Cache<String, Binding> getClusteredCache() {
        return this.cache.getCache();
    }

    public void setClusteredCache(Cache<String, Binding> cache) {
        if (this.treeRootSet) {
            throw new IllegalStateException("Cannot change clusteredCache after call to init()");
        }
        this.cache = new TreeCacheFactory().createTreeCache(cache);
    }

    public void setRootFqn(String rootFqn) {
        if (this.treeRootSet) {
            throw new IllegalStateException("Cannot change rootFqn after call to init()");
        }
        this.m_root = rootFqn == null ? null : Fqn.fromString((String)rootFqn);
    }

    public String getRootFqn() {
        return this.m_root == null ? DEFAULT_ROOT : this.m_root.toString();
    }

    public void init() {
        if (this.cache == null) {
            throw new IllegalStateException("No clustered cache available");
        }
        log.debug((Object)"initializing HAJNDITreeCache root");
        this.putTreeRoot();
    }

    public void shutdown() {
        this.cache = null;
    }

    public void bind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("bind, name=" + name));
        }
        this.internalBind(name, obj, className, false);
    }

    public void rebind(Name name, Object obj, String className) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("rebind, name=" + name));
        }
        this.internalBind(name, obj, className, true);
    }

    public void unbind(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("unbind, name=" + name));
        }
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        try {
            Fqn temp = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)Fqn.fromString((String)name.toString()));
            if (this.cache.getRoot().hasChild(temp)) {
                this.cache.removeNode(temp);
                return;
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        try {
            Object removed = this.cache.remove(ctx, (Object)key);
            if (removed == null) {
                if (!this.cache.getRoot().hasChild(ctx)) {
                    throw new NotContextException(name.getPrefix(size - 1).toString() + " not a context");
                }
                throw new NameNotFoundException(key + " not bound");
            }
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Object lookup(Name name) throws NamingException {
        Fqn ctx;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("lookup, name=" + name));
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        try {
            Binding b = (Binding)this.cache.get(ctx, (Object)key);
            return b != null ? b.getObject() : null;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Collection<NameClassPair> list(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("list, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return Collections.list(new InitialContext().list(name));
            }
            catch (NamingException e) {
                throw new NotContextException(ctxName + " not a context");
            }
        }
        try {
            LinkedList<NameClassPair> list = new LinkedList<NameClassPair>();
            Node base = this.cache.getRoot().getChild(ctx);
            if (base != null) {
                for (Binding b : base.getData().values()) {
                    list.add(new NameClassPair(b.getName(), b.getClassName(), true));
                }
                Set children = base.getChildrenNames();
                if (children != null && !children.isEmpty()) {
                    for (Object child : children) {
                        String node = (String)child;
                        Name fullName = (Name)name.clone();
                        fullName.add(node);
                        list.add(new NameClassPair(node, NamingContext.class.getName(), true));
                    }
                }
            }
            return list;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public Collection<PseudoBinding> listBindings(Name name) throws NamingException {
        Fqn ctx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("listBindings, name=" + name));
        }
        String ctxName = "";
        int size = name.size();
        if (size >= 1) {
            ctxName = name.toString();
            Fqn fqn = Fqn.fromString((String)ctxName);
            ctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.cache.getRoot().hasChild(ctx);
        if (!exists) {
            try {
                return PseudoBinding.convert(new InitialContext().listBindings(name));
            }
            catch (NamingException e) {
                throw new NotContextException(ctxName + " not a context");
            }
        }
        try {
            LinkedList<PseudoBinding> list = new LinkedList<PseudoBinding>();
            Node node = this.cache.getRoot().getChild(ctx);
            if (node != null) {
                Set children;
                Map data = node.getData();
                if (data != null && !data.isEmpty()) {
                    list.addAll(PseudoBinding.convert(data.values()));
                }
                if ((children = node.getChildrenNames()) != null && !children.isEmpty()) {
                    for (Object obj : children) {
                        String child = (String)obj;
                        Name fullName = (Name)name.clone();
                        fullName.add(child);
                        list.add(new PseudoBinding(fullName, child));
                    }
                }
            }
            return list;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    public void createSubcontext(Name name) throws NamingException {
        Fqn pctx;
        int size;
        if (log.isTraceEnabled()) {
            log.trace((Object)("createSubcontext, name=" + name));
        }
        if ((size = name.size()) == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        String str = name.toString();
        Fqn fqn = Fqn.fromString((String)str);
        Fqn ctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn);
        if (this.cache.getRoot().hasChild(ctx)) {
            throw new NameAlreadyBoundException();
        }
        String newctx = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn2 = Fqn.fromString((String)prefix);
            pctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn2);
        } else {
            pctx = this.m_root;
        }
        boolean exists = this.cache.getRoot().hasChild(pctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString());
        }
        Fqn newf = Fqn.fromRelativeFqn((Fqn)pctx, (Fqn)Fqn.fromString((String)newctx));
        try {
            this.cache.put(newf, new HashMap());
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }

    private void putTreeRoot() throws CacheException {
        if (this.m_root == null) {
            this.setRootFqn(DEFAULT_ROOT);
        }
        if (!this.cache.getRoot().hasChild(this.m_root)) {
            this.cache.put(this.m_root, Collections.emptyMap());
            this.treeRootSet = true;
        }
    }

    private void internalBind(Name name, Object obj, String className, boolean rebind) throws NamingException {
        Node node;
        Fqn ctx;
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        int size = name.size();
        String key = name.get(size - 1);
        if (size > 1) {
            String prefix = name.getPrefix(size - 1).toString();
            Fqn fqn = Fqn.fromString((String)prefix);
            ctx = Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)fqn);
        } else {
            ctx = this.m_root;
        }
        boolean exists = this.cache.getRoot().hasChild(ctx);
        if (!exists) {
            throw new NotContextException(name.getPrefix(size - 1).toString() + " not a context");
        }
        if (!rebind && (node = this.cache.getRoot().getChild(ctx)) != null && node.get((Object)key) != null) {
            throw new NameAlreadyBoundException(key);
        }
        this.cache.put(ctx, (Object)key, (Object)new Binding(key, className, obj, true));
    }

    public boolean isContextName(Name name) throws NamingException {
        try {
            return this.cache.getRoot().getChild(Fqn.fromRelativeFqn((Fqn)this.m_root, (Fqn)Fqn.fromString((String)name.toString()))) != null;
        }
        catch (CacheException ce) {
            NamingException ne = new NamingException(((Object)((Object)ce)).getClass().getName() + ": " + ce.getMessage());
            ne.setStackTrace(ce.getStackTrace());
            throw ne;
        }
    }
}

