/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.legacy.jnp.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.legacy.jnp.connector.clustered.HAConnectorLegacyService;
import org.jboss.legacy.jnp.connector.clustered.HAConnectorService;
import org.jboss.legacy.jnp.server.JNPServerResourceDefinition;
import org.jboss.legacy.jnp.server.JNPServerService;
import org.jboss.legacy.jnp.server.clustered.HAServerService;
import org.jboss.legacy.jnp.server.simple.SingleServerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class JNPServerServiceAddStepHandler
extends AbstractBoottimeAddStepHandler {
    public static final JNPServerServiceAddStepHandler INSTANCE = new JNPServerServiceAddStepHandler();

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        newControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ServiceBuilder serviceBuilder;
        JNPServerService service;
        boolean isHA = JNPServerResourceDefinition.HA.resolveModelAttribute(context, operation).asBoolean(false);
        ServiceTarget serviceTarget = context.getServiceTarget();
        if (isHA) {
            service = new HAServerService();
            serviceBuilder = serviceTarget.addService(JNPServerService.SERVICE_NAME, (Service)service);
            serviceBuilder.addDependency(HAConnectorService.SERVICE_NAME, HAConnectorLegacyService.class, ((HAServerService)service).getHAConnectorLegacyService());
        } else {
            service = new SingleServerService();
            serviceBuilder = serviceTarget.addService(JNPServerService.SERVICE_NAME, (Service)service);
            serviceBuilder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, ((SingleServerService)service).getNamingStoreInjector());
        }
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController remotingServiceController = serviceBuilder.install();
        ArrayList installedServices = new ArrayList();
        installedServices.add(remotingServiceController);
        return installedServices;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
    }
}

