/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers.managed;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.system.ServiceConfigurator;
import org.jboss.system.ServiceController;
import org.jboss.system.deployers.managed.ManagementObjectClass;
import org.jboss.system.deployers.managed.SecurityActions;
import org.jboss.system.metadata.ServiceAnnotationMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceElementValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetaDataICF
implements InstanceClassFactory<ServiceMetaData> {
    private static final Logger log = Logger.getLogger(ServiceMetaDataICF.class);
    private static final String MOCLASS_ANNOTATION = '@' + ManagementObjectClass.class.getName();
    private MBeanServer mbeanServer;
    private ServiceController controller;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public ServiceController getController() {
        return this.controller;
    }

    public void setController(ServiceController controller) {
        this.controller = controller;
    }

    public Class<ServiceMetaData> getType() {
        return ServiceMetaData.class;
    }

    public Class<? extends Serializable> getManagedObjectClass(ServiceMetaData md) throws ClassNotFoundException {
        Class clazz;
        ClassLoader prevLoader = SecurityActions.getContextClassLoader();
        try {
            ClassLoader loader = this.getServiceMetaDataCL(md);
            Class moClass = loader.loadClass(md.getCode());
            SecurityActions.setContextClassLoader(loader);
            List<ServiceAnnotationMetaData> samlist = md.getAnnotations();
            for (ServiceAnnotationMetaData sam : samlist) {
                String anString = sam.getAnnotation();
                if (!anString.startsWith(MOCLASS_ANNOTATION)) continue;
                Class originalClass = moClass;
                ManagementObjectClass moc = (ManagementObjectClass)sam.getAnnotationInstance(loader);
                moClass = moc.code();
                log.debug((Object)("Using alternate class '" + moClass + "' for class " + originalClass));
                break;
            }
            clazz = moClass;
            Object var12_12 = null;
        }
        catch (InstanceNotFoundException e) {
            try {
                throw new ClassNotFoundException("Failed to obtain mbean class loader", e);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                SecurityActions.setContextClassLoader(prevLoader);
                throw throwable;
            }
        }
        SecurityActions.setContextClassLoader(prevLoader);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, MetaData metaData, ServiceMetaData md) {
        String name = property.getMappedName();
        if (name == null) {
            name = property.getName();
        }
        ClassLoader prevLoader = SecurityActions.getContextClassLoader();
        Object value = null;
        MetaType metaType = property.getMetaType();
        MetaValue mvalue = null;
        ObjectName mbean = md.getObjectName();
        String attrName = null;
        try {
            try {
                block22: {
                    ClassLoader loader = this.getServiceMetaDataCL(md);
                    SecurityActions.setContextClassLoader(loader);
                    for (ServiceAttributeMetaData amd : md.getAttributes()) {
                        if (!amd.getName().equalsIgnoreCase(name)) continue;
                        value = amd.getValue();
                        attrName = amd.getName();
                        break;
                    }
                    if (value == null && this.getMbeanServer() != null) {
                        try {
                            value = this.getMbeanServer().getAttribute(mbean, name);
                        }
                        catch (AttributeNotFoundException e) {
                            String attribute = name;
                            attribute = Character.isUpperCase(name.charAt(0)) ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : Character.toUpperCase(name.charAt(0)) + name.substring(1);
                            try {
                                value = this.getMbeanServer().getAttribute(mbean, attribute);
                            }
                            catch (Exception e2) {
                                log.debug((Object)("Failed to get value from mbean for: " + attribute), (Throwable)e2);
                            }
                        }
                        catch (Exception e) {
                            log.debug((Object)("Failed to get value from mbean for: " + name), (Throwable)e);
                        }
                    }
                    try {
                        if (value instanceof ServiceTextValueMetaData) {
                            ServiceTextValueMetaData text = (ServiceTextValueMetaData)value;
                            try {
                                HashMap<String, MBeanAttributeInfo> attrs = ServiceConfigurator.getAttributeMap(this.mbeanServer, mbean);
                                MBeanAttributeInfo mbi = attrs.get(attrName);
                                ServiceValueContext svc = new ServiceValueContext(this.mbeanServer, this.controller, mbi, loader);
                                value = text.getValue(svc);
                            }
                            catch (Exception e) {
                                PropertyEditor editor = PropertyEditorFinder.getInstance().find(BeanUtils.findClass((String)metaType.getTypeName()));
                                editor.setAsText(text.getText());
                                value = editor.getValue();
                            }
                            break block22;
                        }
                        if (value instanceof ServiceDependencyValueMetaData) {
                            ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)value;
                            value = depends.getObjectName();
                            break block22;
                        }
                        if (value instanceof ServiceElementValueMetaData) {
                            value = ((ServiceElementValueMetaData)value).getElement();
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)("Failed to get value from mbean for: " + name), (Throwable)e);
                    }
                }
                PropertyInfo propertyInfo = beanInfo.getProperty(name);
                MetaMapper metaMapper = (MetaMapper)property.getTransientAttachment(MetaMapper.class);
                try {
                    mvalue = metaMapper != null ? metaMapper.createMetaValue(property.getMetaType(), value) : this.metaValueFactory.create(value, propertyInfo.getType());
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to get property value for bean: " + beanInfo.getName() + ", property: " + propertyInfo.getName()), (Throwable)e);
                    MetaValue metaValue = mvalue = this.metaValueFactory.create(null, propertyInfo.getType());
                    Object var18_24 = null;
                    SecurityActions.setContextClassLoader(prevLoader);
                    return metaValue;
                }
                Object var18_25 = null;
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Failed to obtain mbean class loader", e);
            }
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            SecurityActions.setContextClassLoader(prevLoader);
            throw throwable;
        }
        SecurityActions.setContextClassLoader(prevLoader);
        return mvalue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
        ClassLoader prevLoader;
        block20: {
            block19: {
                prevLoader = SecurityActions.getContextClassLoader();
                try {
                    try {
                        String aname;
                        ClassLoader loader = this.getServiceMetaDataCL(md);
                        SecurityActions.setContextClassLoader(loader);
                        String name = property.getMappedName();
                        if (name == null) {
                            name = property.getName();
                        }
                        ServiceValueMetaData attributeValue = null;
                        for (ServiceAttributeMetaData amd : md.getAttributes()) {
                            if (!amd.getName().equalsIgnoreCase(name)) continue;
                            attributeValue = amd.getValue();
                            break;
                        }
                        Object plainValue = null;
                        MetaType propertyType = property.getMetaType();
                        MetaMapper metaMapper = (MetaMapper)property.getTransientAttachment(MetaMapper.class);
                        Type mappedType = null;
                        if (metaMapper != null) {
                            mappedType = metaMapper.mapToType();
                            plainValue = metaMapper.unwrapMetaValue(value);
                        } else {
                            PropertyInfo propertyInfo = beanInfo.getProperty(name);
                            plainValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
                        }
                        if (attributeValue == null && (aname = this.mapAttributeName(md, name)) != null) {
                            String textValue;
                            ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
                            attr.setName(aname);
                            if (mappedType != null && mappedType.equals(Element.class)) {
                                attributeValue = new ServiceElementValueMetaData();
                            } else if (plainValue != null && (textValue = String.valueOf(plainValue)).trim().length() > 0) {
                                attributeValue = new ServiceTextValueMetaData(textValue);
                            }
                            if (attributeValue == null) {
                                Object var17_17 = null;
                                break block19;
                            }
                            attr.setValue(attributeValue);
                            md.addAttribute(attr);
                        }
                        if (attributeValue == null) throw new IllegalArgumentException("No matching attribute found: " + name + "/" + md);
                        if (attributeValue instanceof ServiceTextValueMetaData) {
                            String textValue = plainValue != null ? String.valueOf(plainValue) : null;
                            ServiceTextValueMetaData text = (ServiceTextValueMetaData)attributeValue;
                            text.setText(textValue);
                            break block20;
                        }
                        if (attributeValue instanceof ServiceElementValueMetaData) {
                            if (plainValue != null) {
                                ((ServiceElementValueMetaData)attributeValue).setElement((Element)plainValue);
                            }
                            break block20;
                        }
                        if (!(attributeValue instanceof ServiceDependencyValueMetaData)) throw new IllegalArgumentException("Unhandled attribute value type: " + name + "/" + md + ", class=" + attributeValue.getClass());
                        ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)attributeValue;
                        if (plainValue instanceof ObjectName) {
                            depends.setObjectName((ObjectName)plainValue);
                            break block20;
                        } else {
                            depends.setDependency(String.valueOf(plainValue));
                        }
                        break block20;
                    }
                    catch (InstanceNotFoundException e) {
                        throw new IllegalStateException("Failed to obtain mbean class loader", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    SecurityActions.setContextClassLoader(prevLoader);
                    throw throwable;
                }
            }
            SecurityActions.setContextClassLoader(prevLoader);
            return;
        }
        Object var17_18 = null;
        SecurityActions.setContextClassLoader(prevLoader);
    }

    public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
        ObjectName objectName = md.getObjectName();
        String canonicalName = objectName.getCanonicalName();
        return canonicalName;
    }

    private ClassLoader getServiceMetaDataCL(ServiceMetaData md) throws InstanceNotFoundException {
        ClassLoader loader = null;
        if (this.mbeanServer != null) {
            loader = this.mbeanServer.getClassLoader(md.getClassLoaderName());
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    private String mapAttributeName(ServiceMetaData md, String name) {
        ObjectName mbean = md.getObjectName();
        String attrName = null;
        try {
            this.mbeanServer.getAttribute(mbean, name);
            attrName = name;
        }
        catch (Exception e) {
            char c = name.charAt(0);
            name = Character.isLowerCase(c) ? Character.toUpperCase(c) + name.substring(1) : Character.toLowerCase(c) + name.substring(1);
            try {
                this.mbeanServer.getAttribute(mbean, name);
                attrName = name;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (attrName == null) {
            char c = name.charAt(0);
            name = Character.toUpperCase(c) + name.substring(1);
            return name;
        }
        return attrName;
    }
}

