/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.pm;

import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;
import org.jboss.logging.Logger;
import org.jboss.mx.persistence.AttributePersistenceManager;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.Classes;
import org.jboss.util.file.Files;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLAttributePersistenceManager
implements AttributePersistenceManager {
    public static final String DATA_DIR_ELEMENT = "data-directory";
    public static final String DEFAULT_BASE_DIR = "data/xmbean-attrs";
    public static final String AL_ROOT_ELEMENT = "attribute-list";
    public static final String AL_ID_ATTRIBUTE = "id";
    public static final String AL_DATE_ATTRIBUTE = "date";
    public static final String AL_ATTRIBUTE_ELEMENT = "attribute";
    public static final String AL_NAME_ATTRIBUTE = "name";
    public static final String AL_TYPE_ATTRIBUTE = "type";
    public static final String AL_NULL_ATTRIBUTE = "null";
    public static final String AL_SERIALIZED_ATTRIBUTE = "serialized";
    public static final String AL_TRUE_VALUE = "true";
    public static final String AL_FALSE_VALUE = "false";
    private static final Logger log = Logger.getLogger(XMLAttributePersistenceManager.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private File dataDir;
    private boolean state;
    private Map idMap;

    public XMLAttributePersistenceManager() {
        log.debug((Object)"Constructed");
    }

    public void create(String version, Element config) throws Exception {
        if (this.getState()) {
            return;
        }
        String baseDir = null;
        if (config == null) {
            baseDir = DEFAULT_BASE_DIR;
        } else {
            if (!config.getTagName().equals(DATA_DIR_ELEMENT)) {
                throw new Exception("expected 'data-directory' XML configuration element, got '" + config.getTagName() + "'");
            }
            baseDir = this.getElementContent(config);
        }
        this.dataDir = this.initDataDir(baseDir, version);
        log.debug((Object)("Using data directory: " + this.dataDir.getCanonicalPath()));
        this.idMap = Collections.synchronizedMap(new HashMap());
        this.setState(true);
    }

    public boolean getState() {
        return this.state;
    }

    public void destroy() {
        this.setState(false);
        this.dataDir = null;
        this.idMap = null;
    }

    public void store(String id, AttributeList attrs) throws Exception {
        log.debug((Object)("store(" + id + ") attrs=" + attrs));
        this.checkActiveState();
        String origId = id;
        id = this.mapId(id);
        if (attrs == null) {
            throw new Exception("store() called with null AttributeList");
        }
        File file = this.checkFileForWrite(id);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Comment comment = doc.createComment(" automatically produced by XMLAttributePersistenceManager ");
        doc.appendChild(comment);
        Element root = doc.createElement(AL_ROOT_ELEMENT);
        root.setAttribute(AL_ID_ATTRIBUTE, origId);
        root.setAttribute(AL_DATE_ATTRIBUTE, dateFormat.format(new Date()));
        doc.appendChild(root);
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            String name = attr.getName();
            Object value = attr.getValue();
            Element element = doc.createElement(AL_ATTRIBUTE_ELEMENT);
            element.setAttribute(AL_NAME_ATTRIBUTE, name);
            if (value == null) {
                element.setAttribute(AL_NULL_ATTRIBUTE, AL_TRUE_VALUE);
                root.appendChild(element);
                continue;
            }
            if (value instanceof Element) {
                element.setAttribute(AL_TYPE_ATTRIBUTE, "org.w3c.dom.Element");
                Node copy = doc.importNode((Element)value, true);
                element.appendChild(copy);
                root.appendChild(element);
                continue;
            }
            Class<?> clazz = value.getClass();
            String type = clazz.getName();
            PropertyEditor peditor = PropertyEditorFinder.getInstance().find(clazz);
            if (peditor != null) {
                peditor.setValue(value);
                element.setAttribute(AL_TYPE_ATTRIBUTE, type);
                element.appendChild(doc.createTextNode(peditor.getAsText()));
                root.appendChild(element);
                continue;
            }
            if (value instanceof Serializable) {
                String encoded = this.encodeAsHexString((Serializable)value);
                if (encoded != null) {
                    element.setAttribute(AL_TYPE_ATTRIBUTE, type);
                    element.setAttribute(AL_SERIALIZED_ATTRIBUTE, AL_TRUE_VALUE);
                    element.appendChild(doc.createTextNode(encoded));
                    root.appendChild(element);
                    continue;
                }
                root.appendChild(doc.createComment(" WARN <attribute name=\"" + name + "\" type=\"" + type + "\"/> could not be serialized "));
                log.warn((Object)("Could not serialize attribute '" + name + "' of type '" + type + "' and value: " + value));
                continue;
            }
            root.appendChild(doc.createComment(" WARN <attribute name=\"" + name + "\" type=\"" + type + "\"/> could not be persisted "));
            log.warn((Object)("Could not find a way to persist attribute '" + name + "' of type '" + type + "' and value: " + value));
        }
        try {
            this.outputXmlFile(doc, file);
        }
        catch (Exception e) {
            log.warn((Object)("Cannot persist AttributeList to: \"" + id + "\""), (Throwable)e);
            throw e;
        }
    }

    public AttributeList load(String id) throws Exception {
        log.debug((Object)("load(" + id + ")"));
        this.checkActiveState();
        id = this.mapId(id);
        if (!this.getState()) {
            return null;
        }
        AttributeList attrs = null;
        File file = this.checkFileForRead(id);
        if (file != null) {
            Document doc = this.parseXmlFile(file);
            NodeList docList = doc.getChildNodes();
            Node root = null;
            for (int i = 0; i < docList.getLength(); ++i) {
                Node node = docList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(AL_ROOT_ELEMENT)) continue;
                root = (Element)node;
                break;
            }
            if (root == null) {
                throw new Exception("Expected XML element: attribute-list");
            }
            attrs = new AttributeList();
            NodeList rootList = root.getChildNodes();
            for (int i = 0; i < rootList.getLength(); ++i) {
                Node node = rootList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(AL_ATTRIBUTE_ELEMENT)) continue;
                Element element = (Element)node;
                String name = element.getAttribute(AL_NAME_ATTRIBUTE);
                if (name.length() <= 0) {
                    throw new Exception("Attribute 'name' must be specified for element 'attribute'");
                }
                if (element.getAttribute(AL_NULL_ATTRIBUTE).toLowerCase().equals(AL_TRUE_VALUE)) {
                    attrs.add(new Attribute(name, null));
                    continue;
                }
                if (element.getAttribute(AL_SERIALIZED_ATTRIBUTE).toLowerCase().equals(AL_TRUE_VALUE)) {
                    String hexStr = this.getElementContent(element);
                    Serializable obj = this.decodeFromHexString(hexStr);
                    if (obj == null) {
                        throw new Exception("Failed to deserialize attribute '" + name + "'");
                    }
                    attrs.add(new Attribute(name, obj));
                    continue;
                }
                String type = element.getAttribute(AL_TYPE_ATTRIBUTE);
                if (type.length() <= 0) {
                    throw new Exception("Attribute 'type' must be specified for name='" + name + "'");
                }
                if (type.equals("org.w3c.dom.Element")) {
                    NodeList nlist = element.getChildNodes();
                    Node el = null;
                    for (int j = 0; j < nlist.getLength(); ++j) {
                        Node n = nlist.item(j);
                        if (n.getNodeType() != 1) continue;
                        el = (Element)n;
                        break;
                    }
                    if (el != null) {
                        attrs.add(new Attribute(name, el.cloneNode(true)));
                        continue;
                    }
                    attrs.add(new Attribute(name, null));
                    continue;
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                try {
                    clazz = cl.loadClass(type);
                }
                catch (ClassNotFoundException e) {
                    throw new Exception("Class not found for attribute '" + name + "' of type '" + type + "'");
                }
                PropertyEditor peditor = PropertyEditorFinder.getInstance().find(clazz);
                if (peditor != null) {
                    String value = this.getElementContent(element);
                    peditor.setAsText(value);
                    attrs.add(new Attribute(name, peditor.getValue()));
                    continue;
                }
                throw new Exception("Cannot find a way to load attribute '" + name + "' of type '" + type + "'");
            }
        }
        log.debug((Object)("load() returns with: " + attrs));
        return attrs;
    }

    public boolean exists(String id) throws Exception {
        this.checkActiveState();
        return new File(this.dataDir, this.mapId(id)).isFile();
    }

    public void remove(String id) throws Exception {
        this.checkActiveState();
        new File(this.dataDir, this.mapId(id)).delete();
    }

    public void removeAll() throws Exception {
        this.checkActiveState();
        String[] files = this.dataDir.list(new XMLFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                new File(this.dataDir, files[i]).delete();
            }
        }
    }

    public String[] listAll() throws Exception {
        this.checkActiveState();
        String[] files = this.dataDir.list(new XMLFilter());
        String[] result = null;
        if (files != null) {
            result = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = this.mapFile(files[i]);
            }
        }
        return result;
    }

    private void setState(boolean state) {
        this.state = state;
    }

    private File initDataDir(String baseDir, String versionTag) throws Exception {
        File dir;
        block6: {
            dir = null;
            try {
                URL fileURL = new URL(baseDir);
                File file = new File(fileURL.getFile());
                if (file.isAbsolute() && !file.exists() && !file.mkdirs()) {
                    throw new FileNotFoundException("Failed to create '" + fileURL + "'.");
                }
                if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
                    throw new FileNotFoundException("The '" + fileURL + "' does not have proper access rights.");
                }
                dir = file;
            }
            catch (Exception e) {
                File homeDir = ServerConfigLocator.locate().getServerHomeDir();
                log.warn((Object)(e.getMessage() + "... Reverting to home dir relative path '" + homeDir + "'"));
                dir = new File(homeDir, baseDir);
                dir.mkdirs();
                if (dir.isDirectory()) break block6;
                throw new Exception("The base directory is not valid: " + dir.getCanonicalPath());
            }
        }
        if (versionTag != null && !versionTag.equals("")) {
            dir = new File(dir, versionTag);
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new Exception("The data directory is not valid: " + dir.getCanonicalPath());
            }
        }
        return dir;
    }

    private String encodeAsHexString(Serializable obj) {
        String retn = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                byte[] bytes = baos.toByteArray();
                StringBuffer sbuf = new StringBuffer(1024);
                for (int i = 0; i < bytes.length; ++i) {
                    sbuf.append(hexDigits[bytes[i] >> 4 & 0xF]);
                    sbuf.append(hexDigits[bytes[i] & 0xF]);
                }
                retn = sbuf.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retn;
    }

    private Serializable decodeFromHexString(String hexStr) {
        int len = hexStr.length() / 2;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int d1;
            char h1 = hexStr.charAt(i * 2);
            char h2 = hexStr.charAt(i * 2 + 1);
            int n = h1 >= 'a' ? 10 + h1 - 97 : (d1 = h1 >= 'A' ? 10 + h1 - 65 : h1 - 48);
            int d2 = h2 >= 'a' ? 10 + h2 - 97 : (h2 >= 'A' ? 10 + h2 - 65 : h2 - 48);
            bytes[i] = (byte)(d1 * 16 + d2);
        }
        Serializable retn = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStreamExt ois = new ObjectInputStreamExt(bais);
            retn = (Serializable)ois.readObject();
            ois.close();
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Cannot deserialize object", (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)"Cought IOException", (Throwable)e);
        }
        return retn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputXmlFile(Document doc, File file) throws Exception {
        DOMSource source = new DOMSource(doc);
        FileOutputStream out = new FileOutputStream(file);
        StreamResult result = new StreamResult(out);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        try {
            xformer.transform(source, result);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseXmlFile(File file) throws Exception {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        FileInputStream in = new FileInputStream(file);
        try {
            doc = builder.parse(in);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        return doc;
    }

    private File checkFileForWrite(String filename) throws Exception {
        File file = new File(this.dataDir, filename);
        if (file.isFile()) {
            if (file.canRead() && file.canWrite()) {
                return file;
            }
            throw new Exception("file '" + filename + "' is not r/w");
        }
        if (file.isDirectory()) {
            throw new Exception(filename + " is a directory!");
        }
        return file;
    }

    private File checkFileForRead(String filename) throws Exception {
        File file = new File(this.dataDir, filename);
        if (file.isFile()) {
            if (file.canRead() && file.canWrite()) {
                return file;
            }
            throw new Exception("file '" + filename + "' is not r/w");
        }
        if (file.isDirectory()) {
            throw new Exception(filename + " is a directory!");
        }
        return null;
    }

    private String getElementContent(Element element) {
        NodeList nlist = element.getChildNodes();
        StringBuffer sbuf = new StringBuffer(1024);
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() != 3) continue;
            sbuf.append(((Text)node).getData());
        }
        return sbuf.toString();
    }

    private void checkActiveState() {
        if (!this.getState()) {
            throw new IllegalStateException("AttributePersistenceManager not active");
        }
    }

    private String mapId(String id) throws Exception {
        if (id == null) {
            throw new Exception("called with null id");
        }
        String file = (String)this.idMap.get(id);
        if (file == null) {
            file = Files.encodeFileName((String)id) + ".xml";
            this.idMap.put(id, file);
        }
        return file;
    }

    private String mapFile(String file) {
        if (file == null) {
            return null;
        }
        file = file.substring(0, file.length() - 4);
        return Files.decodeFileName((String)file);
    }

    private class ObjectInputStreamExt
    extends ObjectInputStream {
        ObjectInputStreamExt(InputStream is) throws IOException {
            super(is);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return Classes.loadClass((String)v.getName());
        }
    }

    private class XMLFilter
    implements FilenameFilter {
        private XMLFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

