/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.Tag;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotatedClassFilter;
import org.jboss.deployment.JSFDeployment;
import org.jboss.metadata.annotation.creator.client.ApplicationClient5MetaDataCreator;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.creator.web.Web25MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.client.spec.ApplicationClient5MetaData;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_ANNOTATED_ATTACHMENT_NAME = "annotated." + EjbJarMetaData.class.getName();
    public static final String CLIENT_ANNOTATED_ATTACHMENT_NAME = "annotated." + ApplicationClientMetaData.class.getName();
    public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();
    private boolean metaDataCompleteIsDefault = false;
    private boolean strictServletSpecCompliance = false;

    public AnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addInput(WebMetaData.class);
        this.addInput(ApplicationClientMetaData.class);
        this.addInput(JSFDeployment.class);
        this.addOutput(EJB_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(CLIENT_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
    }

    public boolean isMetaDataCompleteIsDefault() {
        return this.metaDataCompleteIsDefault;
    }

    public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
        this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.undeploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        boolean isComplete = this.isMetaDataCompleteIsDefault();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        if (ejbJarMetaData != null && ejbJarMetaData instanceof EjbJar3xMetaData) {
            isComplete |= ((EjbJar3xMetaData)ejbJarMetaData).isMetadataComplete();
        } else if (ejbJarMetaData != null) {
            isComplete = true;
        }
        WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        if (webMetaData != null && webMetaData instanceof Web25MetaData) {
            isComplete |= ((Web25MetaData)webMetaData).isMetadataComplete();
        } else if (webMetaData != null) {
            isComplete = true;
        }
        ApplicationClientMetaData clientMetaData = (ApplicationClientMetaData)unit.getAttachment(ApplicationClientMetaData.class);
        if (clientMetaData != null) {
            isComplete |= clientMetaData.isMetadataComplete();
        }
        if (isComplete) {
            this.log.debug((Object)("Deployment is metadata-complete, skipping annotation processing, ejbJarMetaData=" + ejbJarMetaData + ", jbossWebMetaData=" + webMetaData + ", jbossClientMetaData=" + clientMetaData + ", metaDataCompleteIsDefault=" + this.metaDataCompleteIsDefault));
            return;
        }
        VirtualFile root = unit.getRoot();
        boolean isLeaf = true;
        try {
            isLeaf = root.isLeaf();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (isLeaf) {
            return;
        }
        List classpath = unit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Deploying annotations for unit: " + unit + ", classpath: " + classpath));
        }
        try {
            this.processMetaData(unit, webMetaData, clientMetaData, classpath);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot process metadata", (Throwable)e);
        }
    }

    protected void processMetaData(VFSDeploymentUnit unit, WebMetaData webMetaData, ApplicationClientMetaData clientMetaData, List<VirtualFile> classpath) throws Exception {
        String mainClassName = this.getMainClassName(unit);
        Collection<Class<?>> classes = this.getClasses(unit, mainClassName, classpath);
        if (classes.size() > 0) {
            DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
            if (webMetaData != null) {
                this.processJBossWebMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
            } else if (clientMetaData != null || mainClassName != null) {
                this.processJBossClientMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
            } else {
                this.processJBossMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
            }
        }
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, String mainClassName, List<VirtualFile> classpath) throws IOException {
        HashMap classpathClasses = new HashMap();
        for (VirtualFile path : classpath) {
            AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, unit.getClassLoader(), path, mainClassName);
            path.visit((VirtualFileVisitor)classVisitor);
            Map<VirtualFile, Class<?>> classes = classVisitor.getAnnotatedClasses();
            if (classes == null || classes.size() <= 0) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Annotated classes: " + classes));
            }
            classpathClasses.putAll(classes);
        }
        return classpathClasses.values();
    }

    protected void undeploy(VFSDeploymentUnit unit) {
    }

    protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        JBoss50Creator creator = new JBoss50Creator(finder);
        JBoss50MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, JBossMetaData.class);
        }
    }

    protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        Web25MetaDataCreator creator = new Web25MetaDataCreator(finder);
        Collection<Class<?>> resourceInjectionEligibleClasses = classes;
        if (this.strictServletSpecCompliance) {
            resourceInjectionEligibleClasses = this.getResourceInjectionEligibleWebAppClasses((DeploymentUnit)unit, classes);
        }
        if (resourceInjectionEligibleClasses.isEmpty()) {
            this.log.debug((Object)("No Java EE injection eligible classes found in web application: " + unit));
            return;
        }
        Web25MetaData annotationMetaData = creator.create(resourceInjectionEligibleClasses);
        if (annotationMetaData != null) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, WebMetaData.class);
        }
    }

    protected void processJBossClientMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        ApplicationClient5MetaDataCreator creator = new ApplicationClient5MetaDataCreator(finder);
        ApplicationClient5MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(CLIENT_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, ApplicationClientMetaData.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMainClassName(VFSDeploymentUnit unit) throws IOException {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("parsing " + file));
        }
        if (file == null) {
            return null;
        }
        try {
            Manifest mf = VFSUtils.readManifest((VirtualFile)file);
            Attributes attrs = mf.getMainAttributes();
            String string = attrs.getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
        finally {
            file.close();
        }
    }

    public boolean isStrictServletSpecCompliance() {
        return this.strictServletSpecCompliance;
    }

    public void setStrictServletSpecCompliance(boolean strictCompliance) {
        this.strictServletSpecCompliance = strictCompliance;
    }

    protected Collection<Class<?>> getResourceInjectionEligibleWebAppClasses(DeploymentUnit unit, Collection<Class<?>> classes) {
        HashSet eligibleClasses = new HashSet();
        if (classes == null || classes.isEmpty()) {
            return eligibleClasses;
        }
        JSFDeployment jsfDeployment = (JSFDeployment)unit.getAttachment(JSFDeployment.class);
        Collection<Class<?>> jsfManagedBeanClasses = this.loadJSFManagedBeanClasses(jsfDeployment, unit);
        block0: for (Class<?> klass : classes) {
            if (klass == null) continue;
            if (Servlet.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (Filter.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (ServletContextListener.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (ServletContextAttributeListener.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (ServletRequestListener.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (ServletRequestAttributeListener.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (HttpSessionListener.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (HttpSessionAttributeListener.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (Tag.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            if (SimpleTag.class.isAssignableFrom(klass)) {
                eligibleClasses.add(klass);
                continue;
            }
            for (Class<?> jsfManagedBeanClass : jsfManagedBeanClasses) {
                if (!klass.isAssignableFrom(jsfManagedBeanClass)) continue;
                eligibleClasses.add(klass);
                continue block0;
            }
        }
        return eligibleClasses;
    }

    private Collection<Class<?>> loadJSFManagedBeanClasses(JSFDeployment jsfDeployment, DeploymentUnit unit) {
        if (jsfDeployment == null) {
            return Collections.emptySet();
        }
        Collection<String> managedBeanClassNames = jsfDeployment.getManagedBeans();
        if (managedBeanClassNames == null || managedBeanClassNames.isEmpty()) {
            return Collections.emptySet();
        }
        ClassLoader cl = unit.getClassLoader();
        HashSet managedBeanClasses = new HashSet(managedBeanClassNames.size());
        for (String managedBeanClassName : managedBeanClassNames) {
            try {
                Class<?> managedBeanClass = Class.forName(managedBeanClassName, false, cl);
                managedBeanClasses.add(managedBeanClass);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.debug((Object)("Ignoring JSF managed bean class " + managedBeanClassName + " since the class cannot be found " + "in classloader " + cl + " of unit " + unit));
            }
        }
        return managedBeanClasses;
    }
}

