/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.jboss.security.javaee.SecurityRoleRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivilegedIfNeeded(PrivilegedAction<T> action) {
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    private static <T> T doPrivilegedIfNeeded(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return AccessController.doPrivileged(action);
    }

    static Object getMBeanProxy(Class iface, ObjectName name, MBeanServer server) throws Exception {
        Object proxy;
        if (System.getSecurityManager() == null) {
            proxy = MBeanProxy.get((Class)iface, (ObjectName)name, (MBeanServer)server);
        } else {
            MBeanProxyAction action = new MBeanProxyAction(iface, name, server);
            proxy = AccessController.doPrivileged(action);
        }
        return proxy;
    }

    static ClassLoader getContextClassLoader() {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader loader) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        });
    }

    static void setContextClassLoader(final Thread thread, final ClassLoader loader) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                thread.setContextClassLoader(loader);
                return null;
            }
        });
    }

    static String setContextID(String contextID) {
        SetContextID action = new SetContextID(contextID);
        String previousID = (String)SecurityActions.doPrivilegedIfNeeded(action);
        return previousID;
    }

    static Principal getCallerPrincipal(SecurityContext sc) {
        return IdentityAction.UTIL.getIdentityAction().getCallerPrincipal(sc);
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static SecurityContext getSecurityContext() {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void setSecurityContext(final SecurityContext securityContext) {
        SecurityActions.doPrivilegedIfNeeded(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                return null;
            }
        });
    }

    static boolean isCallerInRole(final SecurityContext sc, final String roleName, final String ejbName, final Principal principal, final Subject contextSubject, final String jaccContextID, final Set<SecurityRoleRef> securityRoleRefs) throws PrivilegedActionException {
        return SecurityActions.doPrivilegedIfNeeded(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                AbstractEJBAuthorizationHelper helper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)sc);
                return helper.isCallerInRole(roleName, ejbName, principal, contextSubject, jaccContextID, securityRoleRefs);
            }
        });
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)((Object)ex);
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    static interface IdentityAction {
        public static final IdentityAction NON_PRIVILEGED = new IdentityAction(){

            public Principal getCallerPrincipal(SecurityContext securityContext) {
                Object caller = null;
                if (securityContext != null && (caller = securityContext.getIncomingRunAs()) == null) {
                    caller = securityContext.getUtil().getUserPrincipal();
                }
                return caller;
            }
        };
        public static final IdentityAction PRIVILEGED = new IdentityAction(){

            public Principal getCallerPrincipal(final SecurityContext securityContext) {
                return (Principal)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Object caller = null;
                        if (securityContext != null && (caller = securityContext.getIncomingRunAs()) == null) {
                            caller = securityContext.getUtil().getUserPrincipal();
                        }
                        return caller;
                    }
                });
            }
        };

        public Principal getCallerPrincipal(SecurityContext var1);

        public static class UTIL {
            static IdentityAction getIdentityAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }

    private static class InvocationHandlerAction
    implements InvocationHandler,
    PrivilegedExceptionAction {
        private Method method;
        private Object[] args;
        private Object mbean;

        private InvocationHandlerAction(Object mbean) {
            this.mbean = mbean;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value;
            this.method = method;
            this.args = args;
            try {
                value = AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            return value;
        }

        public Object run() throws Exception {
            Object value = this.method.invoke(this.mbean, this.args);
            return value;
        }
    }

    private static class MBeanProxyAction
    implements PrivilegedExceptionAction {
        Class iface;
        ObjectName name;
        MBeanServer server;

        MBeanProxyAction(Class iface, ObjectName name, MBeanServer server) {
            this.iface = iface;
            this.name = name;
            this.server = server;
        }

        public Object run() throws Exception {
            Object proxy = MBeanProxy.get((Class)this.iface, (ObjectName)this.name, (MBeanServer)this.server);
            Class[] ifaces = new Class[]{this.iface};
            InvocationHandlerAction secureHandler = new InvocationHandlerAction(proxy);
            Object secureProxy = Proxy.newProxyInstance(this.iface.getClassLoader(), ifaces, (InvocationHandler)secureHandler);
            return secureProxy;
        }
    }

    private static class SetContextID
    implements PrivilegedAction {
        String contextID;

        SetContextID(String contextID) {
            this.contextID = contextID;
        }

        public Object run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return previousID;
        }
    }
}

