/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.net.Socket;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.IdentityFactory;
import org.jboss.security.identity.IdentityType;
import org.jboss.security.identity.extensions.CertificateIdentity;
import org.jboss.security.identity.extensions.CertificateIdentityFactory;
import org.jboss.security.identity.extensions.CredentialIdentity;

public class SSLSessionInterceptor
extends AbstractInterceptor {
    private CertificatePrincipal cpMapping = new SubjectDNMapping();
    private String sessionIDKey = "SESSION_ID";

    public Object invokeHome(Invocation mi) throws Exception {
        this.extractSessionPrincipal(mi);
        Object returnValue = this.getNext().invokeHome(mi);
        return returnValue;
    }

    public CertificatePrincipal getPrincialMapping() {
        return this.cpMapping;
    }

    public void setPrincialMapping(CertificatePrincipal cpMapping) {
        this.cpMapping = cpMapping;
    }

    public String getSessionIDKey() {
        return this.sessionIDKey;
    }

    public void setSessionIDKey(String sessionIDKey) {
        this.sessionIDKey = sessionIDKey;
    }

    public Object invoke(Invocation mi) throws Exception {
        this.extractSessionPrincipal(mi);
        Object returnValue = this.getNext().invoke(mi);
        return returnValue;
    }

    private void extractSessionPrincipal(Invocation mi) throws SSLPeerUnverifiedException {
        Socket socket;
        String sessionID = (String)mi.getValue(this.sessionIDKey);
        if (sessionID != null && (socket = mi.getSocket()) != null && socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)socket).getSession();
            if (session == null) {
                this.log.warn((Object)"Found SSLSocket, but no session");
                return;
            }
            X509Certificate[] certs = (X509Certificate[])session.getPeerCertificates();
            Principal caller = this.cpMapping.toPrinicipal(certs);
            mi.setPrincipal(caller);
            mi.setCredential(certs);
            SecurityContext invSC = mi.getSecurityContext();
            if (invSC != null) {
                CertificateIdentityFactory identityFactory = (CertificateIdentityFactory)IdentityFactory.getFactory((IdentityType)IdentityType.CERTIFICATE);
                CertificateIdentity certIdentity = identityFactory.createIdentity(caller, certs, null);
                invSC.getUtil().clearIdentities(CredentialIdentity.class);
                invSC.getUtil().addIdentity((Identity)certIdentity);
            }
        }
    }
}

