/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;

abstract class AbstractDeployment
extends AbstractMojo {
    private String name;
    private String hostname;
    private int port;
    private File targetDir;
    private String filename;

    AbstractDeployment() {
    }

    public final String name() {
        return this.name;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final int port() {
        return this.port;
    }

    public final File targetDirectory() {
        return this.targetDir;
    }

    public final String filename() {
        return this.filename;
    }

    public final File file() {
        return new File(this.targetDir, this.filename);
    }

    public abstract DeploymentPlan createPlan(DeploymentPlanBuilder var1) throws IOException;

    public abstract String goal();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File file = new File(this.targetDir, this.filename);
            InetAddress host = InetAddress.getByName(this.hostname);
            String s = Character.toUpperCase(this.goal().charAt(0)) + this.goal().substring(1);
            this.getLog().info((CharSequence)String.format("%sing %s to %s (%s) port %s.", s, file, host.getHostName(), host.getHostAddress(), this.port));
            ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)host, (int)this.port);
            ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)client);
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan.getDeploymentActions().size() > 0) {
                ServerDeploymentPlanResult result = (ServerDeploymentPlanResult)manager.execute(plan).get();
                this.getLog().info((CharSequence)String.format("Deployment Plan Id : %s", result.getDeploymentPlanId()));
            } else {
                this.getLog().warn((CharSequence)String.format("File %s has not been %sed. No deployment actions exist. Plan: %s", this.goal(), this.filename(), plan));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not %s %s. Reason: %s", this.goal(), this.filename(), e.getMessage()), e);
        }
    }
}

