/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.common;

import java.util.List;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.ClientConstants;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class Operations
extends ClientConstants {
    public static final String CHILD_TYPE = "child-type";
    public static final String ENABLE = "enable";
    public static final String LAUNCH_TYPE = "launch-type";
    public static final String PROFILE = "profile";
    public static final String READ_ATTRIBUTE = "read-attribute";
    public static final String READ_CHILDREN_NAMES = "read-children-names";
    public static final String READ_RESOURCE = "read-resource";
    public static final String RECURSIVE = "recursive";
    public static final String RELOAD = "reload";
    public static final String REMOVE = "remove";
    public static final String SERVER_STATE = "server-state";
    public static final String SHUTDOWN = "shutdown";

    public static boolean successful(ModelNode result) {
        return result.get("outcome").asString().equals("success");
    }

    public static String getFailureDescription(ModelNode result) {
        if (Operations.successful(result)) {
            return "";
        }
        String msg = result.hasDefined("failure-description") ? (result.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", result.get("operation"), result.get("address"), result.get("failure-description")) : String.format("Operation failed: %s", result.get("failure-description"))) : String.format("An unexpected response was found checking the deployment. Result: %s", result);
        return msg;
    }

    public static ModelNode createAddOperation(ModelNode address) {
        return Operations.createOperation("add", address);
    }

    public static ModelNode createRemoveOperation(ModelNode address, boolean recursive) {
        return Operations.createOperation(REMOVE, address, recursive);
    }

    public static ModelNode createListDeploymentsOperation() {
        ModelNode op = Operations.createOperation(READ_CHILDREN_NAMES);
        op.get(CHILD_TYPE).set("deployment");
        return op;
    }

    public static ModelNode createCompositeOperation() {
        ModelNode op = Operations.createOperation("composite");
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        op.get("rollback-on-runtime-failure").set(true);
        op.get("steps").setEmptyList();
        return op;
    }

    public static ModelNode createReadAttributeOperation(String attributeName) {
        ModelNode op = new ModelNode();
        op.get("address").setEmptyList();
        op.get("operation").set(READ_ATTRIBUTE);
        op.get("name").set(attributeName);
        return op;
    }

    public static ModelNode createOperation(String operation) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operation);
        op.get("address").setEmptyList();
        return op;
    }

    public static ModelNode createOperation(String operation, ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        ModelNode op = Operations.createOperation(operation);
        op.get("address").set(address);
        return op;
    }

    public static ModelNode createOperation(String operation, ModelNode address, boolean recursive) {
        ModelNode op = Operations.createOperation(operation, address);
        op.get(RECURSIVE).set(recursive);
        return op;
    }

    public static Property getChildAddress(ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        List addressParts = address.asPropertyList();
        if (addressParts.isEmpty()) {
            throw new IllegalArgumentException("The address is empty.");
        }
        return (Property)addressParts.get(addressParts.size() - 1);
    }

    public static ModelNode getParentAddress(ModelNode address) {
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("The address type must be a list.");
        }
        ModelNode result = new ModelNode();
        List addressParts = address.asPropertyList();
        if (addressParts.isEmpty()) {
            throw new IllegalArgumentException("The address is empty.");
        }
        for (int i = 0; i < addressParts.size() - 1; ++i) {
            Property property = (Property)addressParts.get(i);
            result.add(property.getName(), property.getValue());
        }
        return result;
    }

    public static String readResultAsString(ModelNode result) {
        return result.hasDefined("result") ? result.get("result").asString() : "";
    }

    public static class CompositeOperationBuilder {
        private final ModelNode op;

        private CompositeOperationBuilder(ModelNode op) {
            this.op = op;
        }

        public static CompositeOperationBuilder create() {
            return new CompositeOperationBuilder(Operations.createCompositeOperation());
        }

        public Operation build() {
            return OperationBuilder.create((ModelNode)this.op).build();
        }

        public CompositeOperationBuilder addStep(ModelNode op) {
            if (!op.hasDefined("operation")) {
                throw new IllegalArgumentException(String.format("Invalid operations: %s", op));
            }
            this.op.get("steps").add(op);
            return this;
        }
    }
}

