/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.plugin.deployment.AbstractDeployment;
import org.jboss.as.plugin.deployment.PackageType;

abstract class AbstractAppDeployment
extends AbstractDeployment {
    @Parameter(defaultValue="${project.build.directory}/", property="jboss-as.deployment.targetDir")
    private File targetDir;
    @Parameter(property="jboss-as.deployment.filename")
    private String filename;
    @Parameter(alias="check-packaging", property="jboss-as.checkPackaging", defaultValue="true")
    private boolean checkPackaging;

    AbstractAppDeployment() {
    }

    @Override
    protected File file() {
        PackageType packageType = this.getPackageType();
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return new File(this.targetDir, filename);
    }

    @Override
    protected final boolean checkPackaging() {
        return this.checkPackaging;
    }
}

