/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jboss.as.plugin.common.IoUtils;

public class Files {
    public static File createFile(File base, String ... paths) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String path : paths) {
            sb.append(path);
            if (path.endsWith(File.separator) || ++count >= paths.length) continue;
            sb.append(File.separator);
        }
        return new File(base, sb.toString());
    }

    public static String createPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String path : paths) {
            sb.append(path);
            if (path.endsWith(File.separator) || ++count >= paths.length) continue;
            sb.append(File.separator);
        }
        return sb.toString();
    }

    public static String getExtension(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' is a directory");
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index > 0 ? name.substring(index + 1) : "";
    }

    public static File dropExtension(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' is a directory");
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index > 0 ? new File(file.getParentFile(), name.substring(0, index)) : file;
    }

    public static boolean deleteRecursively(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                if (!(f.isDirectory() ? !Files.deleteRecursively(f) : !f.delete())) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File zipFile, File targetDir) throws IOException {
        File file = Files.requiresExtraction(zipFile) ? Files.extract(zipFile) : zipFile;
        ArchiveInputStream in = null;
        try {
            ArchiveEntry entry;
            in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
            byte[] buff = new byte[1024];
            while ((entry = in.getNextEntry()) != null) {
                File extractTarget = new File(targetDir.getAbsolutePath(), entry.getName());
                if (entry.isDirectory()) {
                    extractTarget.mkdirs();
                    continue;
                }
                File parent = new File(extractTarget.getParent());
                parent.mkdirs();
                BufferedOutputStream out = null;
                try {
                    int read;
                    out = new BufferedOutputStream(new FileOutputStream(extractTarget));
                    while ((read = in.read(buff)) != -1) {
                        out.write(buff, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    IoUtils.safeClose(out);
                    throw throwable;
                }
                IoUtils.safeClose(out);
            }
        }
        catch (ArchiveException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(in);
                throw throwable;
            }
        }
        IoUtils.safeClose((Closeable)in);
    }

    private static boolean requiresExtraction(File file) {
        String extension = Files.getExtension(file);
        return "bzip2".equals(extension) || "gz".equals(extension) || "pack200".equals(extension) || "xz".equals(extension);
    }

    private static File extract(File file) throws IOException {
        File f = Files.dropExtension(file);
        File tempFile = File.createTempFile(Files.dropExtension(f).getName(), Files.getExtension(f));
        tempFile.deleteOnExit();
        BufferedInputStream in = null;
        FileOutputStream out = null;
        CompressorInputStream compressorIn = null;
        try {
            int i;
            in = new BufferedInputStream(new FileInputStream(file));
            out = new FileOutputStream(tempFile);
            compressorIn = new CompressorStreamFactory().createCompressorInputStream((InputStream)in);
            byte[] buffer = new byte[1024];
            while ((i = compressorIn.read(buffer)) != -1) {
                out.write(buffer, 0, i);
            }
        }
        catch (CompressorException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(in);
                IoUtils.safeClose(out);
                IoUtils.safeClose(compressorIn);
                throw throwable;
            }
        }
        IoUtils.safeClose(in);
        IoUtils.safeClose(out);
        IoUtils.safeClose((Closeable)compressorIn);
        return tempFile;
    }
}

