/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.project.MavenProject;

final class PackageType
implements Comparable<PackageType> {
    private static final PackageType MAVEN_PLUGIN = new PackageType("maven-project", true);
    private static final PackageType POM = new PackageType("pom", true);
    private static final PackageType EJB = new PackageType("ejb", "jar");
    private static final Map<String, PackageType> DEFAULT_TYPES = new HashMap<String, PackageType>();
    private final String packaging;
    private final String fileExtension;
    private final boolean ignored;

    private PackageType(String packaging) {
        this(packaging, packaging, false);
    }

    private PackageType(String packaging, boolean ignored) {
        this(packaging, packaging, ignored);
    }

    private PackageType(String packaging, String fileExtension) {
        this(packaging, fileExtension, false);
    }

    private PackageType(String packaging, String fileExtension, boolean ignored) {
        this.packaging = packaging;
        this.fileExtension = fileExtension;
        this.ignored = ignored;
    }

    public static PackageType resolve(MavenProject project) {
        String packaging = project.getPackaging().toLowerCase(Locale.ROOT);
        if (DEFAULT_TYPES.containsKey(packaging)) {
            return DEFAULT_TYPES.get(packaging);
        }
        return new PackageType(packaging);
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PackageType)) {
            return false;
        }
        PackageType other = (PackageType)obj;
        return this.packaging == null ? other.packaging == null : this.packaging.equals(other.packaging);
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (this.packaging == null ? 0 : this.packaging.hashCode());
        return result;
    }

    public String toString() {
        return String.format("%s[packaging=%s,translatedPackaging=%s]", PackageType.class.getName(), this.packaging, this.fileExtension);
    }

    @Override
    public int compareTo(PackageType o) {
        return this.packaging.compareTo(o.packaging);
    }

    static {
        DEFAULT_TYPES.put(PackageType.MAVEN_PLUGIN.packaging, MAVEN_PLUGIN);
        DEFAULT_TYPES.put(PackageType.POM.packaging, MAVEN_PLUGIN);
        DEFAULT_TYPES.put(PackageType.EJB.packaging, MAVEN_PLUGIN);
    }
}

