/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.controller;

import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Stateful;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.jboss.as.quickstarts.kitchensink.model.Member;

@Stateful
@Model
public class MemberRegistration {
    @Inject
    private Logger log;
    @Inject
    private EntityManager em;
    @Inject
    private Event<Member> memberEventSrc;
    private Member newMember;

    @Produces
    @Named
    public Member getNewMember() {
        return this.newMember;
    }

    public void register() throws Exception {
        this.log.info("Registering " + this.newMember.getName());
        this.em.persist((Object)this.newMember);
        this.memberEventSrc.fire((Object)this.newMember);
        this.initNewMember();
    }

    @PostConstruct
    public void initNewMember() {
        this.newMember = new Member();
    }
}

