/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.data;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.as.quickstarts.kitchensink.model.Member;

@RequestScoped
public class MemberListProducer {
    @Inject
    private EntityManager em;
    private List<Member> members;

    @Produces
    @Named
    public List<Member> getMembers() {
        return this.members;
    }

    public void onMemberListChanged(@Observes(notifyObserver=Reception.IF_EXISTS) Member member) {
        this.retrieveAllMembersOrderedByName();
    }

    @PostConstruct
    public void retrieveAllMembersOrderedByName() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).orderBy(new Order[]{cb.asc((Expression)member.get("name"))});
        this.members = this.em.createQuery(criteria).getResultList();
    }
}

