/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.reflect.Method;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMScript;

public class BMRunnerUtil {
    public static String normaliseLoadDirectory(BMScript annotation) {
        String loadDirectory = annotation.dir();
        if (loadDirectory != null && loadDirectory.length() > 0) {
            return loadDirectory;
        }
        return null;
    }

    public static String constructScriptText(BMRule[] bmRules) {
        StringBuilder builder = new StringBuilder();
        builder.append("# BMUnit autogenerated script ");
        for (BMRule bmRule : bmRules) {
            String helper;
            builder.append("\nRULE ");
            builder.append(bmRule.name());
            if (bmRule.isInterface()) {
                builder.append("\nINTERFACE ");
            } else {
                builder.append("\nCLASS ");
            }
            if (bmRule.isOverriding()) {
                builder.append("^");
            }
            builder.append(bmRule.targetClass());
            builder.append("\nMETHOD ");
            builder.append(bmRule.targetMethod());
            String location = bmRule.targetLocation();
            if (location != null && location.length() > 0) {
                builder.append("\nAT ");
                builder.append(location);
            }
            if ((helper = bmRule.helper()) != null && helper.length() > 0) {
                builder.append("\nHELPER ");
                builder.append(helper);
            }
            builder.append("\nIF ");
            builder.append(bmRule.condition());
            builder.append("\nDO ");
            builder.append(bmRule.action());
            builder.append("\nENDRULE\n");
        }
        return builder.toString();
    }

    public static String computeBMScriptName(String name, Method method) {
        if (name != null && name.length() > 0) {
            return name;
        }
        return method.getName();
    }

    public static String computeBMScriptName(String name) {
        if (name != null && name.length() > 0) {
            return name;
        }
        return null;
    }
}

