/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import org.jboss.byteman.contrib.dtest.RemoteInterface;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class BytemanTestHelper
extends Helper {
    public static final String RMIREGISTRY_PORT_PROPERTY_NAME = "org.jboss.byteman.contrib.dtest.rmiregistry.port";
    private static Map<String, Map<Object, Integer>> targetInstances = new HashMap<String, Map<Object, Integer>>();
    private static Registry registry;

    public BytemanTestHelper(Rule rule) throws Exception {
        super(rule);
        if (registry == null) {
            String propertyValue = System.getProperty(RMIREGISTRY_PORT_PROPERTY_NAME);
            int rmiPort = Integer.parseInt(propertyValue);
            registry = LocateRegistry.getRegistry(rmiPort);
        }
    }

    public boolean debug(String text, Object object0) {
        super.debug(text + " " + object0.toString());
        return true;
    }

    public void remoteTrace(String className, String methodName, Object[] dollarStar) throws Exception {
        Object targetObject;
        Integer objectId;
        Map<Object, Integer> knownInstancesOfType = targetInstances.get(className);
        if (knownInstancesOfType == null) {
            knownInstancesOfType = new HashMap<Object, Integer>();
            targetInstances.put(className, knownInstancesOfType);
        }
        if ((objectId = knownInstancesOfType.get(targetObject = dollarStar[0])) == null) {
            objectId = knownInstancesOfType.size();
            knownInstancesOfType.put(targetObject, objectId);
        }
        Object[] args = this.convertForRemoting(dollarStar);
        args[0] = objectId;
        RemoteInterface server = (RemoteInterface)registry.lookup(className);
        server.trace(methodName, args);
    }

    private Object[] convertForRemoting(Object[] input) {
        Object[] output = new Object[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i] == null ? null : input[i].toString();
        }
        return output;
    }
}

