/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

public class RuleBuilder {
    private String ruleName;
    private String className;
    private boolean isInterface;
    private String methodName;
    private String helperName;
    private String atClause = "ENTRY";
    private String ifClause = "true";
    private String doClause;
    private static String LINEBREAK = "\n";

    public static void main(String[] args) {
        RuleBuilder rb = new RuleBuilder("myRule");
        rb.onClass("org.jboss.byteman.ExampleClass").inMethod("doInterestingStuff").atEntry().whenTrue().doAction("myAction()");
        System.out.println(rb);
    }

    public RuleBuilder(String ruleName) {
        this.ruleName = ruleName;
    }

    public RuleBuilder onClass(Class clazz) {
        return this.onSpecifier(clazz.getCanonicalName(), false);
    }

    public RuleBuilder onClass(String className) {
        return this.onSpecifier(className, false);
    }

    public RuleBuilder onInterface(Class clazz) {
        return this.onSpecifier(clazz.getCanonicalName(), true);
    }

    public RuleBuilder onInterface(String className) {
        return this.onSpecifier(className, true);
    }

    private RuleBuilder onSpecifier(String className, boolean isInterface) {
        this.className = className;
        this.isInterface = isInterface;
        return this;
    }

    public RuleBuilder inMethod(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public RuleBuilder usingHelper(Class helperClass) {
        return this.usingHelper(helperClass.getCanonicalName());
    }

    public RuleBuilder usingHelper(String helperName) {
        this.helperName = helperName;
        return this;
    }

    public RuleBuilder at(String at) {
        this.atClause = at;
        return this;
    }

    public RuleBuilder atEntry() {
        return this.at("ENTRY");
    }

    public RuleBuilder atExit() {
        return this.at("EXIT");
    }

    public RuleBuilder atLine(int line) {
        return this.at("LINE " + line);
    }

    public RuleBuilder when(String condition) {
        this.ifClause = condition;
        return this;
    }

    public RuleBuilder whenTrue() {
        return this.when("true");
    }

    public RuleBuilder whenFalse() {
        return this.when("false");
    }

    public RuleBuilder when(boolean when) {
        return this.when("" + when);
    }

    public RuleBuilder doAction(String action) {
        this.doClause = action;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RULE ");
        stringBuilder.append(this.ruleName);
        stringBuilder.append(LINEBREAK);
        if (this.isInterface) {
            stringBuilder.append("INTERFACE ");
        } else {
            stringBuilder.append("CLASS ");
        }
        stringBuilder.append(this.className);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("METHOD ");
        stringBuilder.append(this.methodName);
        stringBuilder.append(LINEBREAK);
        if (this.helperName != null) {
            stringBuilder.append("HELPER ");
            stringBuilder.append(this.helperName);
            stringBuilder.append(LINEBREAK);
        }
        stringBuilder.append("AT ");
        stringBuilder.append(this.atClause);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("IF ");
        stringBuilder.append(this.ifClause);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("DO ");
        stringBuilder.append(this.doClause);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("ENDRULE");
        stringBuilder.append(LINEBREAK);
        return stringBuilder.toString();
    }
}

