/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.byteman.contrib.dtest.CallCount;
import org.junit.Assert;

public class InstrumentedInstance {
    private final String className;
    private final Integer instanceId;
    private final Queue<String> methodTraces = new ConcurrentLinkedQueue<String>();

    InstrumentedInstance(String className, Integer instanceId) {
        this.className = className;
        this.instanceId = instanceId;
    }

    void addMethodTrace(String methodName, Object[] args) {
        this.methodTraces.add(methodName);
    }

    public int getInvocationCount(String methodName) {
        int count = 0;
        for (String name : this.methodTraces) {
            if (!methodName.equals(name)) continue;
            ++count;
        }
        return count;
    }

    public void assertMethodCallCount(String message, String methodName, CallCount callCount) {
        int invocationCount = this.getInvocationCount(methodName);
        String assertInfo = (message == null ? "" : message + " - ") + String.format("Method %s#%s ", this.className, methodName);
        if (callCount.getMin() == callCount.getMax()) {
            Assert.assertTrue((String)(assertInfo + "required call count " + callCount.getMin() + " but was " + invocationCount), (callCount.getMin() == invocationCount ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)(assertInfo + "required minimum call count " + callCount.getMin() + " but was " + invocationCount), (callCount.getMin() <= invocationCount ? 1 : 0) != 0);
            Assert.assertTrue((String)(assertInfo + "required maximum call count " + callCount.getMax() + " but was " + invocationCount), (callCount.getMax() >= invocationCount ? 1 : 0) != 0);
        }
    }
}

