/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.dtest;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.byteman.contrib.dtest.Instrumentor;
import org.jboss.byteman.rule.helper.Helper;

public final class RuleConstructor {
    private static AtomicReference<Instrumentor> defaultInstrumentor = new AtomicReference();
    private static final String LINEBREAK = String.format("%n", new Object[0]);
    private static final String CONSTRUCTOR_METHOD = "<init>";
    private static final String CLASS_CONSTRUCTOR = "<clinit>";
    private String ruleName;
    private String className;
    private boolean isInterface;
    private boolean isIncludeSubclases;
    private String methodName;
    private String helperName = Helper.class.getName();
    private String where = "AT ENTRY";
    private String bind;
    private String ifcondition = "true";
    private String action;
    private String imports;
    private String compile;

    private RuleConstructor(String ruleName) {
        this.ruleName = ruleName;
    }

    public static final void setDefaultInstrumentor(Instrumentor instrumentor) {
        defaultInstrumentor.set(instrumentor);
    }

    public static final void undefineDefaultInstrumentor() {
        RuleConstructor.setDefaultInstrumentor(null);
    }

    public static final Instrumentor getDefaultInstrumentor() {
        return defaultInstrumentor.get();
    }

    public static final ClassClause createRule(String ruleName) {
        return new RuleConstructor(ruleName).new ClassClause();
    }

    public RuleConstructor install() {
        if (defaultInstrumentor.get() == null) {
            throw new IllegalStateException("Can't install rule '" + this.getRuleName() + "' as default instrumentor was not set-up");
        }
        return this.install(defaultInstrumentor.get());
    }

    public RuleConstructor install(Instrumentor instrumentor) {
        if (instrumentor == null) {
            throw new NullPointerException("instrumentor");
        }
        try {
            instrumentor.installRule(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't install rule '" + this.getRuleName() + "'", e);
        }
        return this;
    }

    public RuleConstructor submit() {
        return this.install();
    }

    public RuleConstructor submit(Instrumentor instrumentor) {
        return this.install(instrumentor);
    }

    public String build() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RULE ");
        stringBuilder.append(this.ruleName);
        stringBuilder.append(LINEBREAK);
        if (this.isInterface) {
            stringBuilder.append("INTERFACE ");
        } else {
            stringBuilder.append("CLASS ");
        }
        if (this.isIncludeSubclases) {
            stringBuilder.append("^");
        }
        stringBuilder.append(this.className);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("METHOD ");
        stringBuilder.append(this.methodName);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append(this.where);
        stringBuilder.append(LINEBREAK);
        if (this.helperName != null && !this.helperName.isEmpty()) {
            stringBuilder.append("HELPER ");
            stringBuilder.append(this.helperName);
            stringBuilder.append(LINEBREAK);
        }
        if (this.imports != null) {
            stringBuilder.append(this.imports);
        }
        if (this.compile != null && !this.compile.isEmpty()) {
            stringBuilder.append(this.compile);
            stringBuilder.append(LINEBREAK);
        }
        if (this.bind != null && !this.bind.isEmpty()) {
            stringBuilder.append("BIND ");
            stringBuilder.append(this.bind);
            stringBuilder.append(LINEBREAK);
        }
        stringBuilder.append("IF ");
        stringBuilder.append(this.ifcondition);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("DO ");
        stringBuilder.append(this.action);
        stringBuilder.append(LINEBREAK);
        stringBuilder.append("ENDRULE");
        stringBuilder.append(LINEBREAK);
        return stringBuilder.toString();
    }

    String getRuleName() {
        return this.ruleName;
    }

    private String stringJoin(String join, String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append(join).append(strings[i]);
        }
        return sb.toString();
    }

    private String stringifyClauses(String ... clauses) {
        StringBuffer actionsBuffer = new StringBuffer();
        boolean isFirstAddition = true;
        boolean isSemicolon = true;
        for (String clause : clauses) {
            if (!isFirstAddition && !isSemicolon) {
                actionsBuffer.append(";");
            }
            if (!isFirstAddition) {
                actionsBuffer.append(LINEBREAK);
            }
            if (!clause.trim().endsWith(";")) {
                isSemicolon = false;
            }
            if (isFirstAddition) {
                isFirstAddition = false;
            }
            actionsBuffer.append(clause.trim());
        }
        return actionsBuffer.toString();
    }

    public final class ActionClause {
        public RuleConstructor doAction(String ... actions) {
            RuleConstructor.this.action = RuleConstructor.this.stringifyClauses(actions);
            return RuleConstructor.this;
        }
    }

    public final class ConditionClause {
        public ConditionClause helper(Class<?> helperClass) {
            return this.helper(helperClass.getCanonicalName());
        }

        public ConditionClause helper(String helperClassName) {
            RuleConstructor.this.helperName = helperClassName;
            return this;
        }

        public ConditionClause bind(String ... bindClauses) {
            RuleConstructor.this.bind = RuleConstructor.this.stringifyClauses(bindClauses);
            return this;
        }

        public ConditionClause imports(String ... imports) {
            StringBuffer importsBuf = new StringBuffer();
            for (String importString : imports) {
                importsBuf.append("IMPORT ").append(importString).append(LINEBREAK);
            }
            RuleConstructor.this.imports = importsBuf.toString();
            return this;
        }

        public ConditionClause compile() {
            RuleConstructor.this.compile = "COMPILE";
            return this;
        }

        public ConditionClause nocompile() {
            RuleConstructor.this.compile = "NOCOMPILE";
            return this;
        }

        public ActionClause ifCondition(String condition) {
            RuleConstructor.this.ifcondition = condition;
            return new ActionClause();
        }

        public ActionClause ifTrue() {
            return this.ifCondition("true");
        }

        public ActionClause ifFalse() {
            return this.ifCondition("false");
        }
    }

    public final class LocationClause {
        public LocationClause helper(Class<?> helperClass) {
            return this.helper(helperClass.getCanonicalName());
        }

        public LocationClause helper(String helperClassName) {
            RuleConstructor.this.helperName = helperClassName;
            return this;
        }

        public ConditionClause atEntry() {
            return this.at("ENTRY");
        }

        public ConditionClause atExit() {
            return this.at("EXIT");
        }

        public ConditionClause atLine(int line) {
            return this.at("LINE " + line);
        }

        public ConditionClause atRead(String variable) {
            return this.at("READ " + variable);
        }

        public ConditionClause atRead(String variable, int occurencePosition) {
            return this.at("READ " + variable + " " + occurencePosition);
        }

        public ConditionClause afterRead(String variable) {
            return this.after("READ " + variable);
        }

        public ConditionClause afterRead(String variable, int occurencePosition) {
            return this.after("READ " + variable + " " + occurencePosition);
        }

        public ConditionClause atWrite(String variable) {
            return this.at("WRITE " + variable);
        }

        public ConditionClause atWrite(String variable, int occurencePosition) {
            return this.at("WRITE " + variable + " " + occurencePosition);
        }

        public ConditionClause afterWrite(String variable) {
            return this.after("WRITE " + variable);
        }

        public ConditionClause afterWrite(String variable, int occurencePosition) {
            return this.after("WRITE " + variable + " " + occurencePosition);
        }

        public ConditionClause atInvoke(String method) {
            return this.at("INVOKE " + method);
        }

        public ConditionClause atInvoke(String method, int occurencePosition) {
            return this.at("INVOKE " + method + " " + occurencePosition);
        }

        public ConditionClause afterInvoke(String method) {
            return this.after("INVOKE " + method);
        }

        public ConditionClause afterInvoke(String method, int occurencePosition) {
            return this.after("INVOKE " + method + " " + occurencePosition);
        }

        public ConditionClause atSynchronize() {
            return this.at("SYNCHRONIZE");
        }

        public ConditionClause atSynchronize(int occurencePosition) {
            return this.at("SYNCHRONIZE " + occurencePosition);
        }

        public ConditionClause afterSynchronize() {
            return this.after("SYNCHRONIZE");
        }

        public ConditionClause afterSynchronize(int occurencePosition) {
            return this.after("SYNCHRONIZE " + occurencePosition);
        }

        public ConditionClause atThrow() {
            return this.at("THROW");
        }

        public ConditionClause atThrow(int occurencePosition) {
            return this.at("THROW " + occurencePosition);
        }

        public ConditionClause atExceptionExit() {
            return this.at("EXCEPTION EXIT");
        }

        public ConditionClause at(String at) {
            return this.where("AT " + at);
        }

        public ConditionClause after(String after) {
            return this.where("AFTER " + after);
        }

        ConditionClause where(String where) {
            RuleConstructor.this.where = where;
            return new ConditionClause();
        }
    }

    public final class MethodClause {
        public MethodClause includeSubclases() {
            RuleConstructor.this.isIncludeSubclases = true;
            return this;
        }

        public LocationClause inMethod(String methodName) {
            RuleConstructor.this.methodName = methodName;
            return new LocationClause();
        }

        public LocationClause inMethod(String methodName, String ... argTypes) {
            RuleConstructor.this.methodName = methodName + "(" + RuleConstructor.this.stringJoin(",", argTypes) + ")";
            return new LocationClause();
        }

        public LocationClause inConstructor() {
            return this.inMethod(RuleConstructor.CONSTRUCTOR_METHOD);
        }

        public LocationClause inConstructor(String ... argTypes) {
            return this.inMethod(RuleConstructor.CONSTRUCTOR_METHOD, argTypes);
        }

        public LocationClause inClassInitMethod() {
            return this.inMethod(RuleConstructor.CLASS_CONSTRUCTOR);
        }

        public LocationClause inClassInitMethod(String ... argTypes) {
            return this.inMethod(RuleConstructor.CLASS_CONSTRUCTOR, argTypes);
        }
    }

    public final class ClassClause {
        public MethodClause onClass(Class<?> clazz) {
            return this.onSpecifier(clazz.getCanonicalName(), false);
        }

        public MethodClause onClass(String className) {
            return this.onSpecifier(className, false);
        }

        public MethodClause onInterface(Class<?> clazz) {
            return this.onSpecifier(clazz.getCanonicalName(), true);
        }

        public MethodClause onInterface(String className) {
            return this.onSpecifier(className, true);
        }

        private MethodClause onSpecifier(String className, boolean isInterface) {
            RuleConstructor.this.className = className;
            RuleConstructor.this.isInterface = isInterface;
            return new MethodClause();
        }
    }
}

