/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.capedwarf.common.serialization.DelegateSerializator;
import org.jboss.capedwarf.common.serialization.Serializator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzipSerializator
extends DelegateSerializator {
    public GzipSerializator(Serializator delegate) {
        super(delegate);
    }

    @Override
    public void serialize(Object instance, OutputStream out) throws IOException {
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        this.delegate.serialize(instance, gzip);
        gzip.finish();
    }

    @Override
    public <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        GZIPInputStream gzip = new GZIPInputStream(stream);
        return this.delegate.deserialize(gzip, clazz);
    }
}

