/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.dto;

import org.jboss.capedwarf.common.dto.Identity;
import org.jboss.capedwarf.common.sql.Column;
import org.json.JSONException;
import org.json.JSONObject;

public class Timestamped
extends Identity {
    private static final long serialVersionUID = 1L;
    private long timestamp;
    private long expirationDelta;

    public boolean isExpired() {
        return this.timestamp + this.expirationDelta < System.currentTimeMillis();
    }

    public void writeJSONObject(JSONObject json) throws JSONException {
        super.writeJSONObject(json);
        if (this.timestamp > 0L) {
            json.put("timestamp", this.timestamp);
        }
        if (this.expirationDelta > 0L) {
            json.put("expirationDelta", this.expirationDelta);
        }
    }

    public void readJSONObject(JSONObject json) throws JSONException {
        super.readJSONObject(json);
        this.timestamp = json.optLong("timestamp", 0L);
        this.expirationDelta = json.optLong("expirationDelta", 0L);
    }

    @Column
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Column
    public long getExpirationDelta() {
        return this.expirationDelta;
    }

    public void setExpirationDelta(long expirationDelta) {
        this.expirationDelta = expirationDelta;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Timestamped other = (Timestamped)obj;
        return this.timestamp == other.timestamp && this.expirationDelta == other.expirationDelta;
    }
}

