/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.data;

import java.io.Serializable;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.jboss.capedwarf.common.data.Status;
import org.jboss.capedwarf.common.serialization.JSONAware;
import org.jboss.capedwarf.common.serialization.JSONUtils;
import org.jboss.capedwarf.validation.api.Email;
import org.jboss.capedwarf.validation.api.MessageTemplateKey;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfo
implements JSONAware,
Serializable {
    private static final long serialVersionUID = 1L;
    private String username;
    private String password;
    private String email;
    private Status status;
    private String recovery;

    @Deprecated
    public UserInfo() {
    }

    public UserInfo(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Null username");
        }
        if (password == null) {
            throw new IllegalArgumentException("Null password");
        }
        this.username = username;
        this.password = password;
    }

    public void writeJSONObject(JSONObject json) throws JSONException {
        json.put("username", (Object)this.username);
        json.put("password", (Object)this.password);
        json.putOpt("email", (Object)this.email);
        JSONUtils.writeEnum(json, "status", this.status);
        json.putOpt("recovery", (Object)this.recovery);
    }

    public void readJSONObject(JSONObject json) throws JSONException {
        this.username = json.getString("username");
        this.password = json.getString("password");
        this.email = json.optString("email");
        this.status = JSONUtils.readEnum(json, "status", null, Status.class);
        this.recovery = json.optString("recovery");
    }

    @Size(min=3, max=20)
    @Pattern(regexp="[a-zA-Z0-9_\\.@\\+\\-]+")
    @MessageTemplateKey(value="{capedwarf.login.username}")
    public String getUsername() {
        return this.username;
    }

    @Size(min=6, max=30)
    @Pattern(regexp="[a-zA-Z0-9_\\.@\\+\\-]+")
    @MessageTemplateKey(value="{capedwarf.login.password}")
    public String getPassword() {
        return this.password;
    }

    @Email
    @MessageTemplateKey(value="{capedwarf.login.email}")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @MessageTemplateKey(value="{capedwarf.login.recovery}")
    public String getRecovery() {
        return this.recovery;
    }

    public void setRecovery(String recovery) {
        this.recovery = recovery;
    }
}

