/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.dto;

import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.capedwarf.common.dto.DTOClass;
import org.jboss.capedwarf.common.dto.DTOModel;
import org.jboss.capedwarf.common.dto.DTOModelFactory;
import org.jboss.capedwarf.common.dto.DefaultDTOModel;
import org.jboss.capedwarf.common.dto.NoopDTOModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDTOModelFactory
implements DTOModelFactory {
    private Map<Class<? extends Serializable>, DTOModel<? extends Serializable>> models = new WeakHashMap<Class<? extends Serializable>, DTOModel<? extends Serializable>>();

    @Override
    public <E extends Serializable> DTOModel<E> createModel(Class<E> clazz) {
        DTOModel model = this.models.get(clazz);
        if (model != null) {
            return model;
        }
        model = this.createModelInternal(clazz);
        this.models.put(clazz, model);
        return model;
    }

    protected <E extends Serializable> DTOModel createModelInternal(Class<E> clazz) {
        DTOClass dtoClass = clazz.getAnnotation(DTOClass.class);
        if (dtoClass == null) {
            throw new IllegalArgumentException("No such DTOClass: " + clazz);
        }
        Class<? extends DTOModel> modelClass = dtoClass.model();
        if (modelClass != DefaultDTOModel.class) {
            try {
                return modelClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (clazz == dtoClass.value()) {
            return new NoopDTOModel();
        }
        return new DefaultDTOModel<E>(clazz);
    }
}

