/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.env;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.jboss.capedwarf.common.env.Environment;
import org.jboss.capedwarf.common.env.EnvironmentType;
import org.jboss.capedwarf.common.env.HackJSONObject;
import org.jboss.capedwarf.common.serialization.JSONUtils;
import org.jboss.capedwarf.common.tools.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class AbstractEnvironment
implements Environment {
    private String charsetName = "UTF-8";

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void touch() {
    }

    public void log(String category, Level level, String msg, Throwable t) {
        if (level == null) {
            this.verbose(category, msg, t);
            return;
        }
        String name = level.getName();
        if (Level.SEVERE.equals(level)) {
            name = "ERROR";
        } else if (Level.CONFIG.equals(level)) {
            name = "DEBUG";
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(String.class);
        types.add(String.class);
        if (t != null) {
            types.add(Throwable.class);
        }
        try {
            Method m = this.getMethod(name, types.toArray(new Class[types.size()]));
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(category);
            args.add(msg);
            if (t != null) {
                args.add(t);
            }
            m.invoke(null, args.toArray(new Object[args.size()]));
        }
        catch (Exception ignored) {
            this.verbose(category, msg, t);
        }
    }

    protected abstract Method getMethod(String var1, Class ... var2);

    protected abstract void verbose(String var1, String var2, Throwable var3);

    public EnvironmentType envType() {
        return EnvironmentType.ANDROID;
    }

    public JSONObject createObject() {
        return new HackJSONObject();
    }

    public JSONObject createObject(JSONTokener tokener) throws JSONException {
        return new HackJSONObject(tokener);
    }

    public JSONTokener createTokener(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copyAndClose(is, baos, false);
        String result = new String(baos.toByteArray(), this.charsetName);
        return new JSONTokener(result);
    }

    public void writeArray(JSONArray array, Writer writer) throws JSONException {
        try {
            boolean b = false;
            int len = array.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = array.get(i)) instanceof JSONObject) {
                    this.writeObject((JSONObject)v, writer);
                } else if (v instanceof JSONArray) {
                    this.writeArray((JSONArray)v, writer);
                } else {
                    writer.write(AbstractEnvironment.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw JSONUtils.createJSONException(e);
        }
    }

    public void writeObject(JSONObject object, Writer writer) throws JSONException {
        try {
            boolean b = false;
            Iterator keys = object.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                String key = (String)keys.next();
                writer.write(JSONObject.quote((String)key));
                writer.write(58);
                Object v = object.get(key);
                if (v instanceof JSONObject) {
                    this.writeObject((JSONObject)v, writer);
                } else if (v instanceof JSONArray) {
                    this.writeArray((JSONArray)v, writer);
                } else {
                    writer.write(AbstractEnvironment.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw JSONUtils.createJSONException(e);
        }
    }

    public long getUserId() {
        return 0L;
    }

    public String getUserToken() {
        return "";
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)((Number)value));
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> collection = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                collection.add(Array.get(value, i));
            }
            return new JSONArray(collection).toString();
        }
        return JSONObject.quote((String)value.toString());
    }
}

