/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.env;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.capedwarf.common.env.Environment;
import org.jboss.capedwarf.common.env.EnvironmentType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class DefaultEnvironment
implements Environment {
    private static long userId = 0L;
    private static String userToken = "dummy-token";

    DefaultEnvironment() {
    }

    static void setUserId(long id) {
        userId = id;
    }

    static void setUserToken(String token) {
        userToken = token;
    }

    public void touch() {
    }

    public void log(String category, Level level, String msg, Throwable t) {
        Logger log = Logger.getLogger(category);
        if (t == null) {
            log.log(level, msg);
        } else {
            log.log(level, msg, t);
        }
    }

    public EnvironmentType envType() {
        return EnvironmentType.GAE;
    }

    public JSONObject createObject() {
        return new JSONObject();
    }

    public JSONObject createObject(JSONTokener tokener) throws JSONException {
        return new JSONObject(tokener);
    }

    public JSONTokener createTokener(InputStream is) {
        try {
            return new JSONTokener((Reader)new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            throw new RuntimeException("ASSERTION FAILED: No UTF-8 support");
        }
    }

    public void writeObject(JSONObject object, Writer writer) throws JSONException {
        object.write(writer);
    }

    public void writeArray(JSONArray array, Writer writer) throws JSONException {
        array.write(writer);
    }

    public long getUserId() {
        return userId;
    }

    public String getUserToken() {
        return userToken;
    }
}

