/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.env;

import java.util.ServiceLoader;
import org.jboss.capedwarf.common.env.DefaultEnvironment;
import org.jboss.capedwarf.common.env.Environment;

public class EnvironmentFactory {
    private static volatile Environment env;

    static void setUserId(long id) {
        DefaultEnvironment.setUserId(id);
    }

    static void setUserToken(String token) {
        DefaultEnvironment.setUserToken(token);
    }

    public static Environment getEnvironment() {
        return EnvironmentFactory.getEnvironment(Environment.class.getClassLoader());
    }

    public static Environment getEnvironment(ClassLoader cl) {
        if (env == null) {
            if (cl == null) {
                cl = Environment.class.getClassLoader();
            }
            ServiceLoader<Environment> envs = ServiceLoader.load(Environment.class, cl);
            for (Environment e : envs) {
                try {
                    e.touch();
                    env = e;
                    return env;
                }
                catch (Throwable ignored) {
                }
            }
            env = new DefaultEnvironment();
        }
        return env;
    }
}

