/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.capedwarf.common.io.Progress;

public class FixedLengthInputStream
extends FilterInputStream
implements Progress {
    private long length = -1L;
    private long readCount = 0L;

    public FixedLengthInputStream(InputStream in, long length) {
        super(in);
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.readCount;
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rc = super.read(b, off, len);
        if (rc != -1) {
            this.readCount += (long)rc;
        }
        return rc;
    }

    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        if (skipped >= 0L) {
            this.readCount += skipped;
        }
        return skipped;
    }

    public void close() throws IOException {
        super.close();
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public long getTotal() {
        return this.length;
    }

    public long getProcessed() {
        return this.readCount;
    }
}

