/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtils {
    public static Object toValue(Class<?> rt, String value) throws Throwable {
        if (String.class == rt) {
            return value;
        }
        if (Boolean.class == rt) {
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Server side exception? - " + value);
        }
        if (Enum.class.isAssignableFrom(rt)) {
            return Enum.valueOf(rt, value);
        }
        Method valueOf = ConverterUtils.boxedClass(rt).getMethod("valueOf", value.getClass());
        return valueOf.invoke(null, value);
    }

    public static Class<?> boxedClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        return type;
    }
}

