/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.capedwarf.common.serialization.DelegateSerializator;
import org.jboss.capedwarf.common.serialization.Serializator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzipOptionalSerializator
extends DelegateSerializator {
    private static ThreadLocal<String> flag = new ThreadLocal();

    public static void disableGzip() {
        flag.remove();
    }

    public static void enableGzip() {
        flag.set("GZIP_ENABLED");
    }

    public static boolean isGzipEnabled() {
        return flag.get() != null;
    }

    public static InputStream wrap(InputStream stream) throws IOException {
        return !GzipOptionalSerializator.isGzipEnabled() || stream instanceof GZIPInputStream ? stream : new GZIPInputStream(stream);
    }

    public static OutputStream wrap(OutputStream stream) throws IOException {
        return !GzipOptionalSerializator.isGzipEnabled() || stream instanceof GZIPOutputStream ? stream : new GZIPOutputStream(stream);
    }

    public GzipOptionalSerializator(Serializator delegate) {
        super(delegate);
    }

    @Override
    public void serialize(Object instance, OutputStream out) throws IOException {
        if (GzipOptionalSerializator.isGzipEnabled()) {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            this.delegate.serialize(instance, gzip);
            gzip.finish();
        } else {
            this.delegate.serialize(instance, out);
        }
    }

    @Override
    public <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        if (GzipOptionalSerializator.isGzipEnabled()) {
            stream = new GZIPInputStream(stream);
        }
        return this.delegate.deserialize(stream, clazz);
    }
}

