/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.jboss.capedwarf.common.serialization.AbstractJSONSerializator;
import org.jboss.capedwarf.common.serialization.BufferedSerializator;
import org.jboss.capedwarf.common.serialization.GzipOptionalSerializator;
import org.jboss.capedwarf.common.serialization.GzipSerializator;
import org.jboss.capedwarf.common.serialization.JSONAware;
import org.jboss.capedwarf.common.serialization.Serializator;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONSerializator
extends AbstractJSONSerializator {
    public static final Serializator INSTANCE = new JSONSerializator();
    public static final Serializator BUFFERED = new BufferedSerializator(INSTANCE);
    public static final Serializator GZIPPED = new GzipSerializator(INSTANCE);
    public static final Serializator GZIPPED_BUFFERED = new GzipSerializator(BUFFERED);
    public static final Serializator OPTIONAL_GZIP = new GzipOptionalSerializator(INSTANCE);
    public static final Serializator OPTIONAL_GZIP_BUFFERED = new GzipOptionalSerializator(BUFFERED);

    private JSONSerializator() {
    }

    @Override
    public boolean isValid(Class<?> clazz) {
        return JSONAware.class.isAssignableFrom(clazz);
    }

    @Override
    protected void serialize(Object instance, Writer writer) throws IOException {
        if (instance == null || !this.isValid(instance.getClass())) {
            throw new IllegalArgumentException("Not a JSONAware instance: " + instance);
        }
        JSONObject jobj = this.createObject();
        try {
            ((JSONAware)instance).writeJSONObject(jobj);
            this.writeObject(jobj, writer);
        }
        catch (JSONException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        if (!this.isValid(clazz)) {
            throw new IllegalArgumentException("Not a JSONAware class: " + clazz);
        }
        try {
            JSONTokener tokener = this.createTokener(stream);
            JSONObject value = this.createObject(tokener);
            T instance = clazz.newInstance();
            ((JSONAware)instance).readJSONObject(value);
            T t = instance;
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            stream.close();
        }
    }
}

