/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.util.ArrayList;
import java.util.List;
import org.jboss.capedwarf.common.serialization.Hack64;
import org.jboss.capedwarf.common.serialization.JSONAware;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    public static JSONException createJSONException(Throwable t) {
        if (t == null) {
            return new JSONException("Undeclared JSON exception.");
        }
        JSONException e = new JSONException("Converting to JSON exception: " + t.getMessage());
        e.initCause(t);
        return e;
    }

    public static void writeArray(JSONObject json, String key, byte[] bytes) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException("Null JSON object");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (bytes != null && bytes.length > 0) {
            String value = Hack64.byteArrayToBase64(bytes);
            json.put(key, (Object)value);
        }
    }

    public static byte[] readArray(JSONObject json, String key) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException("Null JSON object");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        String value = json.optString(key);
        if (value != null) {
            return Hack64.base64ToByteArray(value);
        }
        return null;
    }

    public static void writeObjects(JSONObject json, String key, Iterable<? extends JSONAware> objects) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException("Null JSON object");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (objects != null) {
            JSONArray array = new JSONArray();
            for (JSONAware jSONAware : objects) {
                JSONObject object = new JSONObject();
                jSONAware.writeJSONObject(object);
                array.put((Object)object);
            }
            json.put(key, (Object)array);
        }
    }

    public static <T extends JSONAware> List<T> readObjects(JSONObject json, String key, Class<T> clazz) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException("Null JSON object");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null JSONAware class");
        }
        JSONArray array = json.optJSONArray(key);
        if (array != null) {
            int n = array.length();
            ArrayList<JSONAware> list = new ArrayList<JSONAware>(n);
            for (int i = 0; i < n; ++i) {
                JSONAware instance;
                try {
                    instance = (JSONAware)clazz.newInstance();
                }
                catch (Exception e) {
                    throw JSONUtils.createJSONException(e);
                }
                JSONObject object = array.getJSONObject(i);
                instance.readJSONObject(object);
                list.add(instance);
            }
            return list;
        }
        return null;
    }

    public static void writeObject(JSONObject json, String key, JSONAware ja) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException("Null JSON object");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (ja != null) {
            JSONObject object = new JSONObject();
            ja.writeJSONObject(object);
            json.put(key, (Object)object);
        }
    }

    public static <T extends JSONAware> T readObject(JSONObject json, String key, Class<T> clazz) throws JSONException {
        if (json == null) {
            throw new IllegalArgumentException("Null JSON object");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null JSONAware class");
        }
        JSONObject object = json.optJSONObject(key);
        if (object != null) {
            JSONAware instance;
            try {
                instance = (JSONAware)clazz.newInstance();
            }
            catch (Exception e) {
                throw JSONUtils.createJSONException(e);
            }
            instance.readJSONObject(object);
            return (T)instance;
        }
        return null;
    }

    public static void writeEnum(JSONObject json, String key, Enum value) throws JSONException {
        if (value != null) {
            json.put(key, (Object)value.name());
        }
    }

    public static <T extends Enum<T>> T readEnum(JSONObject json, String key, T defaultValue, Class<T> enumClass) throws JSONException {
        String name = json.optString(key);
        return name != null && name.length() > 0 ? Enum.valueOf(enumClass, name) : defaultValue;
    }
}

