/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.jboss.capedwarf.common.serialization.DelegateSerializator;
import org.jboss.capedwarf.common.serialization.Serializator;
import org.jboss.capedwarf.common.tools.DebugTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedSerializator
extends DelegateSerializator {
    public BufferedSerializator(Serializator delegate) {
        super(delegate);
    }

    @Override
    public void serialize(Object instance, OutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.delegate.serialize(instance, baos);
        baos.flush();
        this.log.log(Level.FINEST, "Content: " + baos.toString());
        out.write(baos.toByteArray());
    }

    @Override
    public <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DebugTools.copyAndClose(stream, baos);
        byte[] buf = baos.toByteArray();
        try {
            return this.delegate.deserialize(new ByteArrayInputStream(buf), clazz);
        }
        catch (IOException e) {
            IOException ioe = new IOException("Content: " + new String(buf));
            ioe.initCause(e);
            throw ioe;
        }
    }
}

