/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.dto;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.capedwarf.common.dto.DTOClass;
import org.jboss.capedwarf.common.dto.DTOModel;
import org.jboss.capedwarf.common.dto.DTOProperty;
import org.jboss.capedwarf.common.dto.Identity;
import org.jboss.capedwarf.common.dto.NoopValueConverter;
import org.jboss.capedwarf.common.dto.StringValueConverter;
import org.jboss.capedwarf.common.dto.ValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDTOModel<U extends Serializable>
implements DTOModel<U> {
    private Class<U> entityClass;
    private boolean needsClassName;
    private Method idMethod;
    private Class<?> dto;
    private Map<Method, Method> properties;
    private Map<String, ValueConverter> converters;

    public DefaultDTOModel(Class<U> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Null entity class");
        }
        this.entityClass = entityClass;
        this.init();
    }

    private void init() {
        DTOClass dtoc = this.entityClass.getAnnotation(DTOClass.class);
        if (dtoc == null) {
            throw new IllegalArgumentException("No such DTOClass: " + this.entityClass);
        }
        this.dto = dtoc.value();
        this.needsClassName = dtoc.needsClassName();
        try {
            this.idMethod = this.entityClass.getMethod("getId", new Class[0]);
            if (this.idMethod.getReturnType() != Long.class) {
                this.idMethod = null;
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            this.properties = new HashMap<Method, Method>();
            this.converters = new HashMap<String, ValueConverter>();
            this.resolve(this.entityClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void resolve(Class<?> clazz) throws Exception {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            DTOProperty dtop = m.getAnnotation(DTOProperty.class);
            if (dtop == null) continue;
            String name = m.getName();
            if (!name.startsWith("get") && !name.startsWith("is")) {
                throw new IllegalArgumentException("Not a getter method: " + m);
            }
            if (this.converters.containsKey(name)) continue;
            String dp = dtop.property();
            String pn = dp != null && dp.length() > 0 ? dp : (name.startsWith("is") ? "set" + name.substring(2) : "s" + name.substring(1));
            Method dtoM = this.dto.getMethod(pn, new Class[0]);
            this.properties.put(m, dtoM);
            ValueConverter vc = this.getVC(dtop);
            this.converters.put(name, vc);
        }
    }

    private ValueConverter getVC(DTOProperty dtop) throws Exception {
        Class<? extends ValueConverter> vcc = dtop.converter();
        if (vcc == NoopValueConverter.class) {
            return NoopValueConverter.INSTANCE;
        }
        if (vcc == StringValueConverter.class) {
            return StringValueConverter.INSTANCE;
        }
        return vcc.newInstance();
    }

    @Override
    public Object toDTO(U entity) {
        try {
            Object dtoInstance = this.dto.newInstance();
            if (dtoInstance instanceof Identity) {
                Identity identity = (Identity)dtoInstance;
                if (this.needsClassName) {
                    identity.setClassName(this.entityClass.getName());
                }
                if (this.idMethod != null) {
                    identity.setId((Long)this.idMethod.invoke(entity, new Object[0]));
                }
            }
            for (Method key : this.properties.keySet()) {
                Method dtoProperty = this.properties.get(key);
                ValueConverter vc = this.converters.get(key.getName());
                Object value = vc.convert(key.invoke(entity, new Object[0]));
                dtoProperty.invoke(dtoInstance, value);
            }
            return dtoInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

