/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.jboss.capedwarf.common.serialization.AbstractSerializator;
import org.jboss.capedwarf.common.serialization.GzipSerializator;
import org.jboss.capedwarf.common.serialization.Serializator;
import org.jboss.capedwarf.common.serialization.SerializatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializator
extends AbstractSerializator {
    public static Serializator INSTANCE = new DefaultSerializator();
    public static Serializator GZIPPED = new GzipSerializator(INSTANCE);

    private DefaultSerializator() {
    }

    @Override
    public void serialize(Object instance, OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(instance);
        oos.flush();
    }

    @Override
    public <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        final ClassLoader cl = SerializatorFactory.getClassLoader(clazz);
        ObjectInputStream ois = new ObjectInputStream(stream){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String className = desc.getName();
                return cl.loadClass(className);
            }
        };
        try {
            T t = clazz.cast(ois.readObject());
            return t;
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException();
            ioe.initCause(cnfe);
            throw ioe;
        }
        finally {
            stream.close();
        }
    }
}

