/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import org.jboss.capedwarf.common.serialization.AbstractJSONSerializator;
import org.jboss.capedwarf.common.serialization.JSONAware;
import org.jboss.capedwarf.common.serialization.JSONAwareInstanceProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJSONCollectionSerializator
extends AbstractJSONSerializator {
    private JSONAwareInstanceProvider instanceProvider;

    public MultiJSONCollectionSerializator(JSONAwareInstanceProvider instanceProvider) {
        if (instanceProvider == null) {
            throw new IllegalArgumentException("Null instance provider");
        }
        this.instanceProvider = instanceProvider;
    }

    @Override
    public boolean isValid(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public void serialize(Object instance, Writer writer) throws IOException {
        if (!(instance instanceof Collection)) {
            throw new IllegalArgumentException("Not a collection: " + instance);
        }
        Collection collection = (Collection)instance;
        JSONArray jarray = new JSONArray();
        try {
            for (JSONAware elt : collection) {
                JSONObject jsonObject = this.createObject();
                elt.writeJSONObject(jsonObject);
                jarray.put((Object)jsonObject);
            }
            this.writeArray(jarray, writer);
        }
        catch (JSONException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        if (!this.isValid(clazz)) {
            throw new IllegalArgumentException("Not a JSONAware class: " + clazz);
        }
        try {
            JSONTokener tokener = this.createTokener(stream);
            JSONArray value = new JSONArray(tokener);
            T instance = clazz.newInstance();
            Collection collection = (Collection)instance;
            for (int i = 0; i < value.length(); ++i) {
                Object ja = this.instanceProvider.createInstance(i);
                ja.readJSONObject(value.getJSONObject(i));
                collection.add(ja);
            }
            T t = instance;
            return t;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            stream.close();
        }
    }
}

