/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.common.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.capedwarf.common.serialization.JSONSerializator;
import org.jboss.capedwarf.common.serialization.Serializator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializatorFactory {
    private static Map<Class, Serializator> map = new WeakHashMap<Class, Serializator>();

    public static Serializator get(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        Serializator serializator = map.get(clazz);
        return serializator != null ? serializator : JSONSerializator.OPTIONAL_GZIP;
    }

    public static void mapSerializator(Class<?> clazz, Serializator serializator) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        if (serializator == null) {
            map.remove(clazz);
        } else {
            if (!serializator.isValid(clazz)) {
                throw new IllegalArgumentException("Class " + clazz + " is not valid for " + serializator);
            }
            map.put(clazz, serializator);
        }
    }

    public static byte[] serialize(Object instance) throws IOException {
        if (instance == null) {
            throw new IllegalArgumentException("Null instance.");
        }
        Class<?> clazz = instance.getClass();
        Serializator serializator = SerializatorFactory.get(clazz);
        return serializator.serialize(instance);
    }

    public static <T> T deserialize(InputStream stream, Class<T> clazz) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class.");
        }
        Serializator serializator = SerializatorFactory.get(clazz);
        return serializator.deserialize(stream, clazz);
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }
}

