/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.connect.config;

import org.apache.http.HttpVersion;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.jboss.capedwarf.connect.config.DefaultConfiguration;
import org.jboss.capedwarf.connect.server.ServerProxyHandler;
import org.jboss.capedwarf.connect.server.ServerProxyInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configuration<T> {
    private static Configuration instance;
    private String hostName;
    private int port;
    private int sslPort;
    private String appContext = "";
    private String clientContext = "client";
    private String secureContext = "secure";
    private boolean isDebugMode;
    private boolean isDebugLogging;
    private boolean isStrictSSL;
    private boolean isStrictPort = true;
    private int connectionTimeout = 30000;
    private HttpVersion httpVersion = HttpVersion.HTTP_1_1;
    private String contentCharset = "UTF-8";
    private SocketFactory plainFactory;
    private SocketFactory sslFactory;
    private Class<T> proxyClass;
    private String httpEndpoint;
    private String sslEndpoint;
    private int soTimeout = 30000;
    private boolean expectContinue = true;
    private boolean staleCheckingEnabled;
    private int socketBufferSize = 8192;
    private String username;
    private String password;
    private boolean repeatRequest;

    public static synchronized <T> Configuration<T> getInstance() {
        if (instance == null) {
            return new DefaultConfiguration();
        }
        return instance;
    }

    public static synchronized <T> void setInstance(Configuration<T> conf) {
        instance = conf;
    }

    public ServerProxyInvocationHandler getServerProxyHandler() {
        return new ServerProxyHandler(this);
    }

    public void invalidate() {
        this.httpEndpoint = null;
        this.sslEndpoint = null;
    }

    protected void validateConfiguration() {
        if (this.hostName == null) {
            throw new IllegalArgumentException("Null host name!");
        }
        if (this.appContext == null) {
            throw new IllegalArgumentException("Null app context!");
        }
    }

    public String getEndpoint(boolean secure) {
        return secure ? this.getSslEndpoint() : this.getHttpEndpoint();
    }

    protected String getHttpEndpoint() {
        if (this.httpEndpoint == null) {
            this.httpEndpoint = this.createURL(this.isStrictSSL(), false, this.port);
        }
        return this.httpEndpoint;
    }

    protected String getSslEndpoint() {
        if (this.sslEndpoint == null) {
            this.sslEndpoint = this.createURL(!this.isDebugMode(), true, this.sslPort);
        }
        return this.sslEndpoint;
    }

    protected String createURL(boolean ssl, boolean secure, int xport) {
        int pos;
        this.validateConfiguration();
        StringBuilder endpointUrl = new StringBuilder("http");
        if (ssl) {
            endpointUrl.append('s');
        }
        if ((pos = this.hostName.indexOf("://")) != -1) {
            if (pos > 0) {
                this.hostName = this.hostName.substring(pos);
            }
        } else {
            endpointUrl.append("://");
        }
        endpointUrl.append(this.hostName);
        if (this.hostName.endsWith("/")) {
            endpointUrl.deleteCharAt(endpointUrl.length() - 1);
        }
        if (this.isStrictPort()) {
            endpointUrl.append(':').append(xport);
        }
        endpointUrl.append("/").append(this.getAppContext());
        if (this.getAppContext().length() > 0) {
            endpointUrl.append("/");
        }
        endpointUrl.append(this.getClientContext()).append("/");
        if (secure) {
            endpointUrl.append(this.getSecureContext()).append("/");
        }
        return endpointUrl.toString();
    }

    public Class<T> getProxyClass() {
        if (this.proxyClass == null) {
            throw new IllegalArgumentException("Null proxy class");
        }
        return this.proxyClass;
    }

    public void setProxyClass(Class<T> proxyClass) {
        this.proxyClass = proxyClass;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void setAppContext(String appContext) {
        this.appContext = appContext;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    public void setClientContext(String clientContext) {
        this.clientContext = clientContext;
    }

    public String getSecureContext() {
        return this.secureContext;
    }

    public void setSecureContext(String secureContext) {
        this.secureContext = secureContext;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    public boolean isDebugLogging() {
        return this.isDebugLogging;
    }

    public void setDebugLogging(boolean isDebugLogging) {
        this.isDebugLogging = isDebugLogging;
    }

    public boolean isStrictSSL() {
        return this.isStrictSSL;
    }

    public void setStrictSSL(boolean strictSSL) {
        this.isStrictSSL = strictSSL;
    }

    public boolean isStrictPort() {
        return this.isStrictPort;
    }

    public void setStrictPort(boolean strictPort) {
        this.isStrictPort = strictPort;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public void setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
    }

    public SocketFactory getPlainFactory() {
        if (this.plainFactory == null) {
            return PlainSocketFactory.getSocketFactory();
        }
        return this.plainFactory;
    }

    public void setPlainFactory(SocketFactory plainFactory) {
        this.plainFactory = plainFactory;
    }

    public SocketFactory getSslFactory() {
        if (this.sslFactory == null) {
            return SSLSocketFactory.getSocketFactory();
        }
        return this.sslFactory;
    }

    public void setSslFactory(SocketFactory sslFactory) {
        this.sslFactory = sslFactory;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isExpectContinue() {
        return this.expectContinue;
    }

    public void setExpectContinue(boolean expectContinue) {
        this.expectContinue = expectContinue;
    }

    public boolean isStaleCheckingEnabled() {
        return this.staleCheckingEnabled;
    }

    public void setStaleCheckingEnabled(boolean staleCheckingEnabled) {
        this.staleCheckingEnabled = staleCheckingEnabled;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRepeatRequest() {
        return this.repeatRequest;
    }

    public void setRepeatRequest(boolean repeatRequest) {
        this.repeatRequest = repeatRequest;
    }
}

