/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.connect.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders {
    public static final String CONTENT_TYPE = "Content-Type";
    private static final ThreadLocal<Set<Header>> tlh = new ThreadLocal();

    public static Set<Header> getHeaders() {
        Set<Header> set = tlh.get();
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public static void clear() {
        Set<Header> set = tlh.get();
        if (set != null) {
            tlh.remove();
            set.clear();
        }
    }

    public static void setContentType(String type) {
        for (Header h : HttpHeaders.getHeaders()) {
            if (!h.getName().equals(CONTENT_TYPE)) continue;
            throw new IllegalArgumentException("Content type already set!");
        }
        HttpHeaders.addHeader(CONTENT_TYPE, type);
    }

    public static void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        HttpHeaders.addHeader((Header)new BasicHeader(name, value));
    }

    public static void addHeader(Header header) {
        if (header == null) {
            throw new IllegalArgumentException("Null header");
        }
        Set<Header> set = tlh.get();
        if (set == null) {
            set = new HashSet<Header>();
            tlh.set(set);
        }
        set.add(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHeaders(Map<String, String> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Null headers");
        }
        boolean success = false;
        try {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                HttpHeaders.addHeader(entry.getKey(), entry.getValue());
            }
            success = true;
        }
        finally {
            if (!success) {
                HttpHeaders.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHeaders(Set<Header> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Null headers");
        }
        boolean success = false;
        try {
            for (Header header : headers) {
                HttpHeaders.addHeader(header);
            }
            success = true;
        }
        finally {
            if (!success) {
                HttpHeaders.clear();
            }
        }
    }
}

